/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.util;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.util.DebuggingUtils;

public class PhysicalMemory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalMemory.class);
    private static final OperatingSystemMXBean OS_BEAN = ManagementFactory.getOperatingSystemMXBean();

    public static Long totalPhysicalMemory() {
        return (Long)PhysicalMemory.getAttribute("getTotalPhysicalMemorySize");
    }

    public static Long freePhysicalMemory() {
        return (Long)PhysicalMemory.getAttribute("getFreePhysicalMemorySize");
    }

    public static Long totalSwapSpace() {
        return (Long)PhysicalMemory.getAttribute("getTotalSwapSpaceSize");
    }

    public static Long freeSwapSpace() {
        return (Long)PhysicalMemory.getAttribute("getFreeSwapSpaceSize");
    }

    public static Long ourCommittedVirtualMemory() {
        return (Long)PhysicalMemory.getAttribute("getCommittedVirtualMemorySize");
    }

    private static <T> T getAttribute(String name) {
        LOGGER.trace("Bean lookup for {}", (Object)name);
        for (Class<?> s = OS_BEAN.getClass(); s != null; s = s.getSuperclass()) {
            T result = PhysicalMemory.invokeyMethod(name, s);
            if (result == null) continue;
            return result;
        }
        int n = 0;
        Class<?>[] classArray = OS_BEAN.getClass().getInterfaces();
        int n2 = classArray.length;
        if (n < n2) {
            Class<?> i = classArray[n];
            T result = PhysicalMemory.invokeyMethod(name, i);
            return result;
        }
        LOGGER.trace("Returning null for {}", (Object)name);
        return null;
    }

    private static <T> T invokeyMethod(String name, Class<?> s) {
        try {
            Object result = s.getMethod(name, new Class[0]).invoke((Object)OS_BEAN, new Object[0]);
            LOGGER.trace("Bean lookup successful using {}, got {}", (Object)s, result);
            return (T)result;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.trace("Bean lookup failed on {}", (Object)s, (Object)e);
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println("Total Physical Memory: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.totalPhysicalMemory()) + "B");
        System.out.println("Free Physical Memory: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.freePhysicalMemory()) + "B");
        System.out.println("Total Swap Space: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.totalSwapSpace()) + "B");
        System.out.println("Free Swap Space: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.freeSwapSpace()) + "B");
        System.out.println("Committed Virtual Memory: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.ourCommittedVirtualMemory()) + "B");
    }
}

