/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.fluent.Content;
import org.apache.hc.client5.http.fluent.ContentResponseHandler;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicResponseBuilder;

public class Response {
    private final ClassicHttpResponse response;
    private boolean consumed;

    Response(ClassicHttpResponse response) {
        this.response = response;
    }

    private void assertNotConsumed() {
        if (this.consumed) {
            throw new IllegalStateException("Response content has been already consumed");
        }
    }

    private void dispose() throws IOException {
        if (this.consumed) {
            return;
        }
        try {
            InputStream content;
            HttpEntity entity = this.response.getEntity();
            if (entity != null && (content = entity.getContent()) != null) {
                content.close();
            }
        }
        finally {
            this.consumed = true;
            this.response.close();
        }
    }

    public void discardContent() {
        try {
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> T handleResponse(HttpClientResponseHandler<T> handler) throws IOException {
        this.assertNotConsumed();
        try {
            T t = handler.handleResponse(this.response);
            return t;
        }
        catch (HttpException ex) {
            throw new ClientProtocolException(ex);
        }
        finally {
            this.dispose();
        }
    }

    public Content returnContent() throws IOException {
        return this.handleResponse(new ContentResponseHandler());
    }

    public HttpResponse returnResponse() throws IOException {
        this.assertNotConsumed();
        try {
            HttpEntity entity = this.response.getEntity();
            ClassicHttpResponse classicHttpResponse = ClassicResponseBuilder.copy(this.response).setEntity(entity != null ? new ByteArrayEntity(EntityUtils.toByteArray(entity), ContentType.parse(entity.getContentType())) : null).build();
            return classicHttpResponse;
        }
        finally {
            this.consumed = true;
            this.response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContent(File file) throws IOException {
        this.assertNotConsumed();
        try {
            int status = this.response.getCode();
            if (status >= 300) {
                throw new HttpResponseException(status, this.response.getReasonPhrase());
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                HttpEntity entity = this.response.getEntity();
                if (entity != null) {
                    entity.writeTo(out);
                }
            }
        }
        finally {
            this.consumed = true;
            this.response.close();
        }
    }
}

