/*
 * Decompiled with CFR 0.152.
 */
package jmccc.cli.launch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import jmccc.microsoft.entity.MicrosoftSession;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.UUIDUtils;

public class CliConfig {
    public MicrosoftSession token;
    public String clientId = UUIDUtils.randomUnsignedUuidBase64();
    private static CliConfig instance;
    private static Path configFile;
    private static final Gson gson;

    public static CliConfig getConfig() {
        return instance;
    }

    public static void initConfig(MinecraftDirectory dir) throws IOException {
        configFile = dir.get("jmccc-cli-config.json");
        instance = Files.exists(configFile, new LinkOption[0]) ? gson.fromJson((Reader)Files.newBufferedReader(configFile), CliConfig.class) : new CliConfig();
    }

    public void writeToFile() throws IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            bw.write(gson.toJson(this));
            bw.flush();
        }
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

