/*
 * Decompiled with CFR 0.152.
 */
package jmccc.cli;

import java.util.concurrent.ExecutionException;
import jmccc.cli.download.CliDownloader;
import jmccc.cli.download.ModLoaderDownloader;
import jmccc.cli.launch.CliAuthenticator;
import jmccc.cli.launch.CliConfig;
import jmccc.cli.launch.CliLauncher;
import jmccc.microsoft.MicrosoftAuthenticator;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.to2mbn.jmccc.auth.Authenticator;
import org.to2mbn.jmccc.auth.OfflineAuthenticator;
import org.to2mbn.jmccc.option.LaunchOption;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.version.Version;

public class Main {
    public static String fullVersion = Main.class.getPackage().getImplementationVersion();
    public static String version;

    public static void main(String ... args) {
        if (fullVersion == null) {
            fullVersion = "dev";
        }
        version = fullVersion.replace("-SNAPSHOT", "");
        System.out.println("JMCCC CLI " + fullVersion);
        try {
            Main.internal(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.closeCli();
        }
    }

    private static void internal(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.accepts("microsoft");
        parser.accepts("bmclapi");
        ArgumentAcceptingOptionSpec<String> offlineOption = parser.accepts("offline").availableUnless("microsoft", new String[0]).withOptionalArg().defaultsTo("Player", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> dirOption = parser.accepts("dir").withOptionalArg().defaultsTo(".minecraft", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> clientIdOption = parser.accepts("clientId").availableIf("microsoft", new String[0]).withOptionalArg();
        ArgumentAcceptingOptionSpec<Integer> memoryOption = parser.accepts("memory").withOptionalArg().ofType(Integer.class).defaultsTo(2048, (Integer[])new Integer[0]);
        NonOptionArgumentSpec<String> versionOption = parser.nonOptions();
        OptionSet options = parser.parse(args);
        String player = (String)offlineOption.value(options);
        String dir = (String)dirOption.value(options);
        String version = (String)versionOption.value(options);
        MinecraftDirectory minecraftDirectory = new MinecraftDirectory(dir);
        boolean isMicrosoftAccount = options.has("microsoft");
        boolean isBmclApi = options.has("bmclapi");
        String clientId = (String)clientIdOption.value(options);
        int memory = (Integer)memoryOption.value(options);
        CliConfig.initConfig(minecraftDirectory);
        if (clientId != null) {
            MicrosoftAuthenticator.setClientId(clientId);
        }
        CliDownloader.init(isBmclApi);
        version = Main.parseVersion(version);
        System.out.println("Version: " + version);
        if (!minecraftDirectory.getVersionJson(version).exists()) {
            System.out.println("Downloading: " + version);
            Version v = CliDownloader.download(minecraftDirectory, version);
            version = v.getVersion();
            System.out.println("Downloaded: " + version);
        }
        Authenticator authenticator = isMicrosoftAccount ? CliAuthenticator.getMicrosoftAuthenticator() : OfflineAuthenticator.name(player);
        LaunchOption option = new LaunchOption(version, authenticator, minecraftDirectory);
        option.setMaxMemory(memory);
        CliLauncher.launch(option);
    }

    private static String parseVersion(String version) throws ExecutionException, InterruptedException {
        if (version == null) {
            version = "release";
        }
        switch (version) {
            case "latest": 
            case "stable": 
            case "release": {
                return CliDownloader.getLatestRelease();
            }
            case "snapshot": {
                return CliDownloader.getLatestSnapshot();
            }
            case "forge": {
                return ModLoaderDownloader.getLatestForge().getVersionName();
            }
            case "liteloader": {
                return ModLoaderDownloader.getLatestLiteLoader().getVersionName();
            }
            case "fabric": {
                return ModLoaderDownloader.getLatestFabric().getVersionName();
            }
            case "fabric-snapshot": {
                return ModLoaderDownloader.getLatestFabricSnapshot().getVersionName();
            }
            case "quilt": {
                return ModLoaderDownloader.getLatestQuilt().getVersionName();
            }
            case "quilt-snapshot": {
                return ModLoaderDownloader.getLatestQuiltSnapshot().getVersionName();
            }
        }
        return version;
    }

    public static void closeCli() {
        System.out.println("JMCCC CLI closing");
        if (CliDownloader.downloader != null) {
            CliDownloader.downloader.shutdown();
        }
        System.exit(0);
    }
}

