/*
 * Decompiled with CFR 0.152.
 */
package jmccc.cli.download;

import java.util.concurrent.ExecutionException;
import jmccc.cli.download.BmclApiProvider;
import jmccc.cli.download.SimpleCallback;
import org.to2mbn.jmccc.mcdownloader.CacheOption;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloadOption;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloader;
import org.to2mbn.jmccc.mcdownloader.MinecraftDownloaderBuilder;
import org.to2mbn.jmccc.mcdownloader.RemoteVersionList;
import org.to2mbn.jmccc.mcdownloader.download.combine.CombinedDownloadTask;
import org.to2mbn.jmccc.mcdownloader.provider.DownloadProviderChain;
import org.to2mbn.jmccc.mcdownloader.provider.MinecraftDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.fabric.FabricDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.forge.ForgeDownloadSource;
import org.to2mbn.jmccc.mcdownloader.provider.liteloader.LiteloaderDownloadProvider;
import org.to2mbn.jmccc.mcdownloader.provider.liteloader.LiteloaderDownloadSource;
import org.to2mbn.jmccc.mcdownloader.provider.quilt.QuiltDownloadProvider;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.util.Builder;
import org.to2mbn.jmccc.version.Library;
import org.to2mbn.jmccc.version.Version;

public class SimpleDownloader {
    public static BmclApiProvider bmclApiProvider = new BmclApiProvider();
    public static ForgeDownloadProvider forgeProvider = new ForgeDownloadProvider((ForgeDownloadSource)bmclApiProvider);
    public static LiteloaderDownloadProvider liteloaderProvider = new LiteloaderDownloadProvider((LiteloaderDownloadSource)bmclApiProvider);
    public static FabricDownloadProvider fabricProvider = new FabricDownloadProvider();
    public static FabricDownloadProvider quiltProvider = new QuiltDownloadProvider();
    public static MinecraftDownloader downloader = MinecraftDownloaderBuilder.create().providerChain((Builder)DownloadProviderChain.create().baseProvider((MinecraftDownloadProvider)bmclApiProvider).addProvider((MinecraftDownloadProvider)forgeProvider).addProvider((MinecraftDownloadProvider)liteloaderProvider).addProvider((MinecraftDownloadProvider)fabricProvider).addProvider((MinecraftDownloadProvider)quiltProvider)).build();

    public static String getLatestRelease() throws ExecutionException, InterruptedException {
        return ((RemoteVersionList)downloader.fetchRemoteVersionList(null, new CacheOption[0]).get()).getLatestRelease();
    }

    public static String getLatestSnapshot() throws ExecutionException, InterruptedException {
        return ((RemoteVersionList)downloader.fetchRemoteVersionList(null, new CacheOption[0]).get()).getLatestSnapshot();
    }

    public static Version download(MinecraftDirectory dir, String version) throws ExecutionException, InterruptedException {
        return (Version)downloader.downloadIncrementally(dir, version, new SimpleCallback(), new MinecraftDownloadOption[0]).get();
    }

    public static void downloadLibrary(MinecraftDirectory dir, Library lib) throws ExecutionException, InterruptedException {
        downloader.download(downloader.getProvider().library(dir, lib), new SimpleCallback()).get();
    }

    public static <T> T get(CombinedDownloadTask<T> task) throws ExecutionException, InterruptedException {
        return (T)downloader.download(task, new SimpleCallback()).get();
    }
}

