/*
 * Decompiled with CFR 0.152.
 */
package jmccc.cli;

import jmccc.cli.download.ModLoaderDownloader;
import jmccc.cli.download.SimpleDownloader;
import jmccc.cli.launch.SimpleLauncher;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.version.Version;

public class Main {
    public static void main(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec playerOption = parser.accepts("player").withOptionalArg().defaultsTo((Object)"Player", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec dirOption = parser.accepts("dir").withOptionalArg().defaultsTo((Object)".minecraft", (Object[])new String[0]);
        NonOptionArgumentSpec versionOption = parser.nonOptions();
        OptionSet options = parser.parse(args);
        String player = (String)playerOption.value(options);
        String dir = (String)dirOption.value(options);
        String version = (String)versionOption.value(options);
        if (version == null) {
            version = "release";
        }
        MinecraftDirectory minecraftDirectory = new MinecraftDirectory(dir);
        switch (version) {
            case "latest": 
            case "stable": 
            case "release": {
                version = SimpleDownloader.getLatestRelease();
                break;
            }
            case "snapshot": {
                version = SimpleDownloader.getLatestSnapshot();
                break;
            }
            case "forge": {
                version = ModLoaderDownloader.getLatestForge().getVersionName();
                break;
            }
            case "liteloader": {
                version = ModLoaderDownloader.getLatestLiteLoader().getVersionName();
                break;
            }
            case "fabric": {
                version = ModLoaderDownloader.getLatestFabric().getVersionName();
                break;
            }
            case "fabric-snapshot": {
                version = ModLoaderDownloader.getLatestFabricSnapshot().getVersionName();
                break;
            }
            case "quilt": {
                version = ModLoaderDownloader.getLatestQuilt().getVersionName();
                break;
            }
            case "quilt-snapshot": {
                version = ModLoaderDownloader.getLatestQuiltSnapshot().getVersionName();
            }
        }
        System.out.println("Version: " + version);
        if (!minecraftDirectory.getVersionJson(version).exists()) {
            Version v = SimpleDownloader.download(minecraftDirectory, version);
            version = v.getVersion();
        }
        SimpleLauncher.launch(minecraftDirectory, version, player);
    }
}

