/*
 * Decompiled with CFR 0.152.
 */
package jmccc.cli;

import java.util.concurrent.ExecutionException;
import jmccc.cli.download.CliDownloader;
import jmccc.cli.download.ModLoaderDownloader;
import jmccc.cli.launch.CliLauncher;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.to2mbn.jmccc.option.MinecraftDirectory;
import org.to2mbn.jmccc.version.Version;

public class Main {
    public static void main(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec playerOption = parser.accepts("player").withOptionalArg().defaultsTo((Object)"Player", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec dirOption = parser.accepts("dir").withOptionalArg().defaultsTo((Object)".minecraft", (Object[])new String[0]);
        NonOptionArgumentSpec versionOption = parser.nonOptions();
        OptionSet options = parser.parse(args);
        String player = (String)playerOption.value(options);
        String dir = (String)dirOption.value(options);
        String version = (String)versionOption.value(options);
        MinecraftDirectory minecraftDirectory = new MinecraftDirectory(dir);
        version = Main.parseVersion(version);
        System.out.println("Version: " + version);
        if (!minecraftDirectory.getVersionJson(version).exists()) {
            Version v = CliDownloader.download(minecraftDirectory, version);
            version = v.getVersion();
        }
        CliLauncher.launch(minecraftDirectory, version, player);
    }

    private static String parseVersion(String version) throws ExecutionException, InterruptedException {
        if (version == null) {
            version = "release";
        }
        switch (version) {
            case "latest": 
            case "stable": 
            case "release": {
                return CliDownloader.getLatestRelease();
            }
            case "snapshot": {
                return CliDownloader.getLatestSnapshot();
            }
            case "forge": {
                return ModLoaderDownloader.getLatestForge().getVersionName();
            }
            case "liteloader": {
                return ModLoaderDownloader.getLatestLiteLoader().getVersionName();
            }
            case "fabric": {
                return ModLoaderDownloader.getLatestFabric().getVersionName();
            }
            case "fabric-snapshot": {
                return ModLoaderDownloader.getLatestFabricSnapshot().getVersionName();
            }
            case "quilt": {
                return ModLoaderDownloader.getLatestQuilt().getVersionName();
            }
            case "quilt-snapshot": {
                return ModLoaderDownloader.getLatestQuiltSnapshot().getVersionName();
            }
        }
        return version;
    }
}

