package cool.taomu.netty;

import cool.taomu.netty.inter.IServerConfigure;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class NettyServer {
  private String host;
  
  private int port;
  
  public NettyServer(final String host, final int port) {
    this.host = host;
    this.port = port;
  }
  
  @Inject
  public void start(final IServerConfigure config) {
    try {
      final int coreNumber = Runtime.getRuntime().availableProcessors();
      final NioEventLoopGroup selectGroup = new NioEventLoopGroup(coreNumber);
      final NioEventLoopGroup ioGroup = new NioEventLoopGroup((coreNumber * 2));
      Runtime _runtime = Runtime.getRuntime();
      _runtime.addShutdownHook(new Thread() {
        @Override
        public void run() {
          selectGroup.shutdownGracefully();
          ioGroup.shutdownGracefully();
        }
      });
      ServerBootstrap serverBootstrap = new ServerBootstrap();
      ServerBootstrap bootstrap = serverBootstrap.group(selectGroup, ioGroup);
      bootstrap = bootstrap.channel(NioServerSocketChannel.class);
      bootstrap.<Integer>option(ChannelOption.SO_BACKLOG, Integer.valueOf(1024));
      config.bootstrap(bootstrap);
      bootstrap.childHandler(new ChannelInitializer<SocketChannel>() {
        @Override
        protected void initChannel(final SocketChannel ch) throws Exception {
          config.pipeline(ch.pipeline(), ch);
        }
      });
      bootstrap.bind(this.host, this.port).sync();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
