/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.netty;

import cool.taomu.netty.inter.IServerConfigure;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class NettyServer {
    private String host;
    private int port;

    public NettyServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Inject
    public void start(final IServerConfigure config) {
        try {
            int coreNumber = Runtime.getRuntime().availableProcessors();
            final NioEventLoopGroup selectGroup = new NioEventLoopGroup(coreNumber);
            final NioEventLoopGroup ioGroup = new NioEventLoopGroup(coreNumber * 2);
            Runtime _runtime = Runtime.getRuntime();
            _runtime.addShutdownHook(new Thread(){

                @Override
                public void run() {
                    selectGroup.shutdownGracefully();
                    ioGroup.shutdownGracefully();
                }
            });
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ServerBootstrap bootstrap = serverBootstrap.group((EventLoopGroup)selectGroup, (EventLoopGroup)ioGroup);
            bootstrap = (ServerBootstrap)bootstrap.channel(NioServerSocketChannel.class);
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
            config.bootstrap(bootstrap);
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    config.pipeline(ch.pipeline(), ch);
                }
            });
            bootstrap.bind(this.host, this.port).sync();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

