/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.netty;

import cool.taomu.netty.inter.IClientConfigure;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class NettyClient {
    private String host;
    private int port;

    public NettyClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Inject
    public void client(final IClientConfigure config) {
        try {
            int coreNumber = Runtime.getRuntime().availableProcessors();
            NioEventLoopGroup group = new NioEventLoopGroup(coreNumber);
            Bootstrap bootstrap = (Bootstrap)new Bootstrap().group((EventLoopGroup)group);
            config.bootstrap(bootstrap);
            Bootstrap _channel = (Bootstrap)bootstrap.channel(NioSocketChannel.class);
            _channel.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    config.pipeline(ch.pipeline(), ch);
                }
            });
            ChannelFuture cf = bootstrap.connect(this.host, this.port).sync();
            config.channel(cf.channel());
            cf.channel().closeFuture().sync();
            group.shutdownGracefully();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

