package cool.taomu.netty;

import cool.taomu.netty.inter.IClientConfigure;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class NettyClient {
  private String host;
  
  private int port;
  
  public NettyClient(final String host, final int port) {
    this.host = host;
    this.port = port;
  }
  
  @Inject
  public void client(final IClientConfigure config) {
    try {
      final int coreNumber = Runtime.getRuntime().availableProcessors();
      EventLoopGroup group = new NioEventLoopGroup(coreNumber);
      Bootstrap bootstrap = new Bootstrap().group(group);
      config.bootstrap(bootstrap);
      Bootstrap _channel = bootstrap.channel(NioSocketChannel.class);
      _channel.handler(new ChannelInitializer<SocketChannel>() {
        @Override
        protected void initChannel(final SocketChannel ch) throws Exception {
          config.pipeline(ch.pipeline(), ch);
        }
      });
      ChannelFuture cf = bootstrap.connect(this.host, this.port).sync();
      config.channel(cf.channel());
      cf.channel().closeFuture().sync();
      group.shutdownGracefully();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
