/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.api.web.entrust;

import cool.lazy.cat.orm.api.base.constant.HttpMethod;
import cool.lazy.cat.orm.api.exception.UnKnowTargetBeanException;
import cool.lazy.cat.orm.api.web.EntryInfo;
import cool.lazy.cat.orm.api.web.FullAutoMappingContext;
import cool.lazy.cat.orm.api.web.entrust.AbstractEntrustController;
import cool.lazy.cat.orm.api.web.entrust.EntrustController;
import cool.lazy.cat.orm.api.web.entrust.executor.ApiMethodExecutor;
import cool.lazy.cat.orm.api.web.entrust.provider.ApiEntryInfoProvider;
import cool.lazy.cat.orm.base.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BasicEntrustController
extends AbstractEntrustController
implements EntrustController {
    protected final int apiPathLength;

    public BasicEntrustController(ApiEntryInfoProvider apiEntryInfoProvider, ApiMethodExecutor apiMethodExecutor, String apiPath) {
        super(apiEntryInfoProvider, apiMethodExecutor, apiPath);
        if (null == apiPath || StringUtil.isEmpty((CharSequence)apiPath)) {
            throw new IllegalArgumentException("apiPath\u4e0d\u80fd\u4e3a\u7a7a");
        }
        char prefix = apiPath.charAt(0);
        char suffix = apiPath.charAt(apiPath.length() - 1);
        if (apiPath.contains("*") || prefix == '/' || prefix == '\\' || suffix == '/' || suffix == '\\') {
            throw new IllegalArgumentException("apiPath\u9996\u5c3e\u4e0d\u80fd\u5305\u542b\u8def\u5f84\u6216\u901a\u914d\u7b26");
        }
        this.apiPathLength = ('/' + apiPath).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequestMapping(value={"#{apiConfig.apiPath}/**"})
    public Object entrust(HttpServletRequest request, HttpServletResponse response) {
        String uri = this.cut(this.urlPathHelper.getRequestUri(request));
        EntryInfo entryInfo = this.apiEntryInfoProvider.provider(uri, HttpMethod.resolve((String)request.getMethod()));
        if (null == entryInfo) {
            throw new UnKnowTargetBeanException("\u672a\u77e5\u8bf7\u6c42");
        }
        try {
            FullAutoMappingContext.setPojoType(entryInfo.getPojoType());
            Object object = this.apiMethodExecutor.execute(request, response, entryInfo);
            return object;
        }
        finally {
            FullAutoMappingContext.removePojoType();
        }
    }

    private String cut(String uri) {
        if (uri.length() > this.apiPathLength) {
            return uri.substring(this.apiPathLength);
        }
        return uri;
    }
}

