/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.api.web;

import cool.lazy.cat.orm.api.base.constant.HttpMethod;
import cool.lazy.cat.orm.api.manager.ApiPojoManager;
import cool.lazy.cat.orm.api.manager.subject.ApiPojoSubject;
import cool.lazy.cat.orm.api.web.EntryInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UriPojoMapping {
    private Map<String, Map<HttpMethod, EntryInfo>> uriMapping = Collections.emptyMap();
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Autowired
    public void initMapping(ApiPojoManager apiPojoManager) {
        List<ApiPojoSubject> apiPojoSubjectList = apiPojoManager.getApiPojoSubjectList();
        this.uriMapping = new HashMap<String, Map<HttpMethod, EntryInfo>>(apiPojoSubjectList.size());
        for (ApiPojoSubject subject : apiPojoSubjectList) {
            List<EntryInfo> entryInfoList = subject.getEntryInfoList();
            for (EntryInfo entryInfo : entryInfoList) {
                this.uriMapping.computeIfAbsent(entryInfo.getFullPath(), m -> new HashMap()).putAll(subject.getEntryInfoMap().get(entryInfo.getFullPath()));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.print(apiPojoSubjectList);
        }
    }

    protected void print(List<ApiPojoSubject> apiPojoSubjectList) {
        ArrayList<UriInfoWrapper> sorted = new ArrayList<UriInfoWrapper>(apiPojoSubjectList.size());
        for (ApiPojoSubject subject : apiPojoSubjectList) {
            for (EntryInfo entryInfo : subject.getEntryInfoList()) {
                sorted.add(new UriInfoWrapper(subject.getPojoType(), entryInfo));
            }
        }
        sorted.sort(Comparator.comparingInt(u -> u.getPojoType().hashCode()));
        sorted.forEach(s -> this.logger.info((Object)(s.getPojoType().getName() + " --> " + s.getEntryInfo().getFullPath() + ": " + Arrays.toString(s.getEntryInfo().getMethods()) + " --> " + s.getEntryInfo().getApi().getName())));
    }

    public Map<HttpMethod, EntryInfo> getByUri(String uri) {
        return this.uriMapping.get(uri);
    }

    public Map<String, Map<HttpMethod, EntryInfo>> getUriMapping() {
        return new HashMap<String, Map<HttpMethod, EntryInfo>>(this.uriMapping);
    }

    private static final class UriInfoWrapper {
        private final Class<?> pojoType;
        private final EntryInfo entryInfo;

        public UriInfoWrapper(Class<?> pojoType, EntryInfo entryInfo) {
            this.pojoType = pojoType;
            this.entryInfo = entryInfo;
        }

        public Class<?> getPojoType() {
            return this.pojoType;
        }

        public EntryInfo getEntryInfo() {
            return this.entryInfo;
        }
    }
}

