/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.api.util;

import cool.lazy.cat.orm.api.manager.ApiPojoManager;
import cool.lazy.cat.orm.api.manager.subject.ApiPojoSubject;
import cool.lazy.cat.orm.api.manager.subject.ApiQueryFilterInfo;
import cool.lazy.cat.orm.base.jdbc.sql.condition.type.ConditionType;
import cool.lazy.cat.orm.base.util.StringUtil;
import cool.lazy.cat.orm.core.base.util.ReflectUtil;
import cool.lazy.cat.orm.core.jdbc.constant.ConditionConstant;
import cool.lazy.cat.orm.core.jdbc.mapping.field.access.FieldAccessor;
import cool.lazy.cat.orm.core.jdbc.mapping.field.access.FieldDescriptor;
import cool.lazy.cat.orm.core.jdbc.sql.condition.SqlCondition;
import cool.lazy.cat.orm.core.jdbc.sql.condition.type.None;
import cool.lazy.cat.orm.core.manager.PojoTableManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ConditionHelper {
    private ConditionHelper() {
    }

    public static SqlCondition convert(Class<?> pojoType, ApiPojoManager apiPojoManager, Map<String, Object> paramMap) {
        if (null == paramMap || paramMap.isEmpty()) {
            return null;
        }
        SqlConditionImpl root = null;
        FieldAccessor fieldAccessor = PojoTableManager.getDefaultInstance().getByPojoType(pojoType).getTableInfo().getFieldMapper().getFieldAccessor();
        fieldAccessor.init();
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            Class<? extends ConditionType> conditionType;
            String key = entry.getKey();
            if (StringUtil.isEmpty((CharSequence)key)) continue;
            FieldDescriptor fieldDescriptor = fieldAccessor.get(key);
            ApiPojoSubject belongApiPojo = (ApiPojoSubject)apiPojoManager.getByPojoType(fieldDescriptor.getTableNode().getPojoType());
            String javaFieldName = fieldDescriptor.getJavaFieldName();
            ApiQueryFilterInfo apiQueryFilterInfo = belongApiPojo.getQueryFilterInfoMap().get(javaFieldName);
            if (null == apiQueryFilterInfo || (conditionType = apiQueryFilterInfo.getQueryFilterType()) == None.class || null == conditionType) continue;
            ConditionType conditionTypeInstance = ConditionConstant.CONDITION_TYPE_CACHE.getOrDefault(conditionType, (ConditionType)ReflectUtil.newInstance(conditionType));
            if (null == root) {
                root = new SqlConditionImpl(key, entry.getValue(), conditionTypeInstance);
                continue;
            }
            root.and(new SqlConditionImpl(key, entry.getValue(), conditionTypeInstance));
        }
        return root;
    }

    private static class SqlConditionImpl
    implements SqlCondition {
        private final String field;
        private final Object value;
        private final ConditionType type;
        private List<SqlCondition> and;
        private List<SqlCondition> or;

        public SqlConditionImpl(String field, Object value, ConditionType type) {
            this.field = field;
            this.value = value;
            this.type = type;
        }

        public String field() {
            return this.field;
        }

        public Object value() {
            return this.value;
        }

        public ConditionType type() {
            return this.type;
        }

        public SqlCondition and(SqlCondition condition) {
            if (null == this.and) {
                this.and = new ArrayList<SqlCondition>();
            }
            this.and.add(condition);
            return this;
        }

        public SqlCondition or(SqlCondition condition) {
            if (null == this.or) {
                this.or = new ArrayList<SqlCondition>();
            }
            this.or.add(condition);
            return this;
        }

        public List<SqlCondition> getAnd() {
            return this.and;
        }

        public List<SqlCondition> getOr() {
            return this.or;
        }

        public List<SqlCondition> flatCondition() {
            return this.and;
        }
    }
}

