/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.api.manager.subject;

import cool.lazy.cat.orm.api.base.anno.ApiPojo;
import cool.lazy.cat.orm.api.base.anno.Entry;
import cool.lazy.cat.orm.api.base.constant.HttpMethod;
import cool.lazy.cat.orm.api.exception.ExistPathApiException;
import cool.lazy.cat.orm.api.manager.subject.ApiQueryFilterInfo;
import cool.lazy.cat.orm.api.util.PathGenerator;
import cool.lazy.cat.orm.api.web.EntryInfo;
import cool.lazy.cat.orm.api.web.EntryInfoImpl;
import cool.lazy.cat.orm.api.web.entrust.method.ApiMethodEntry;
import cool.lazy.cat.orm.base.util.Caster;
import cool.lazy.cat.orm.base.util.CollectionUtil;
import cool.lazy.cat.orm.base.util.StringUtil;
import cool.lazy.cat.orm.core.jdbc.mapping.parameter.AbstractParameterizationInfo;
import cool.lazy.cat.orm.core.manager.subject.Subject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApiPojoSubject
extends AbstractParameterizationInfo
implements Subject {
    protected final Class<?> pojoType;
    protected String nameSpace;
    protected Map<String, Map<HttpMethod, EntryInfo>> entryInfoMap = Collections.emptyMap();
    protected List<EntryInfo> entryInfoList = Collections.emptyList();
    protected Map<String, ApiQueryFilterInfo> queryFilterInfoMap = Collections.emptyMap();

    public ApiPojoSubject(Class<?> pojoType) {
        this.pojoType = pojoType;
    }

    public void init(ApiPojo apiPojoAnnotation) {
        if (null != apiPojoAnnotation) {
            this.entryInfoMap = new HashMap<String, Map<HttpMethod, EntryInfo>>(apiPojoAnnotation.entry().length);
            this.entryInfoList = new ArrayList<EntryInfo>(apiPojoAnnotation.entry().length);
            this.nameSpace = PathGenerator.format(apiPojoAnnotation.nameSpace());
            if (StringUtil.isBlank((CharSequence)this.nameSpace)) {
                String name = this.pojoType.getSimpleName();
                this.nameSpace = PathGenerator.format(StringUtil.upper2Lower((String)name));
            }
            for (Entry entry : apiPojoAnnotation.entry()) {
                if (entry.api().isInterface()) {
                    throw new IllegalArgumentException("\u4e0d\u662f\u4e00\u4e2aApiMethodEntry\u5b9e\u73b0\u7c7b\uff1a" + entry.api().getName());
                }
                if (!ApiMethodEntry.class.isAssignableFrom(entry.api())) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7c7b\u578b, \u8bf7\u81ea\u5b9a\u4e49\u5b9e\u73b0: " + entry.api());
                }
                if (CollectionUtil.isEmpty((Object[])entry.methods())) {
                    throw new IllegalArgumentException("method\u4e3a\u7a7a\uff1a" + entry.path());
                }
                String fullPath = this.nameSpace + PathGenerator.format(entry.path());
                EntryInfoImpl entryMethod = new EntryInfoImpl(this.pojoType, this.nameSpace, fullPath, (Class)Caster.cast((Object)entry.api()), entry.methods(), entry.parameters());
                for (HttpMethod httpMethod : entryMethod.getMethods()) {
                    if (this.entryInfoMap.get(entryMethod.getFullPath()) != null && this.entryInfoMap.get(entryMethod.getFullPath()).containsKey(httpMethod)) {
                        throw new ExistPathApiException("\u5df2\u5b58\u5728\u7684path\uff1a\u4ee3\u7406\u7c7b" + this.pojoType.getName() + "[value\uff1a" + entryMethod.getFullPath() + "\uff0ctype\uff1a" + Arrays.toString(entry.methods()) + "]");
                    }
                    this.entryInfoMap.computeIfAbsent(entryMethod.getFullPath(), l -> new HashMap()).put(httpMethod, entryMethod);
                }
                this.entryInfoList.add(entryMethod);
            }
            super.initParameter(apiPojoAnnotation.parameters());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ApiPojoSubject that = (ApiPojoSubject)((Object)o);
        return Objects.equals(this.nameSpace, that.nameSpace);
    }

    public int hashCode() {
        return this.nameSpace != null ? this.nameSpace.hashCode() : 0;
    }

    public Class<?> getPojoType() {
        return this.pojoType;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public Map<String, Map<HttpMethod, EntryInfo>> getEntryInfoMap() {
        return this.entryInfoMap;
    }

    public List<EntryInfo> getEntryInfoList() {
        return this.entryInfoList;
    }

    public Map<String, ApiQueryFilterInfo> getQueryFilterInfoMap() {
        return this.queryFilterInfoMap;
    }

    public void setQueryFilterInfoMap(Map<String, ApiQueryFilterInfo> queryFilterInfoMap) {
        this.queryFilterInfoMap = queryFilterInfoMap;
    }
}

