/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.api.manager;

import cool.lazy.cat.orm.api.base.anno.ApiPojo;
import cool.lazy.cat.orm.api.base.anno.ApiQueryFilter;
import cool.lazy.cat.orm.api.base.constant.HttpMethod;
import cool.lazy.cat.orm.api.exception.ExistNameSpaceException;
import cool.lazy.cat.orm.api.exception.SamePathApiException;
import cool.lazy.cat.orm.api.manager.ApiPojoManager;
import cool.lazy.cat.orm.api.manager.subject.ApiPojoSubject;
import cool.lazy.cat.orm.api.manager.subject.ApiQueryFilterInfo;
import cool.lazy.cat.orm.api.web.EntryInfo;
import cool.lazy.cat.orm.core.jdbc.mapping.field.attr.PojoField;
import cool.lazy.cat.orm.core.manager.PojoManager;
import cool.lazy.cat.orm.core.manager.PojoTableManager;
import cool.lazy.cat.orm.core.manager.exception.UnKnowPojoException;
import cool.lazy.cat.orm.core.manager.subject.PojoSubject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiPojoManagerImpl
implements ApiPojoManager {
    protected Map<Class<?>, ApiPojoSubject> apiPojoSubjectMap;
    protected Map<String, ApiPojoSubject> nameSpaceMap;

    @Autowired
    public void initSubject(PojoManager pojoManager, PojoTableManager pojoTableManager) {
        List subjectList = pojoManager.getPojoSubjectList().stream().filter(p -> p.getPojoType().getAnnotation(ApiPojo.class) != null).collect(Collectors.toList());
        this.apiPojoSubjectMap = new HashMap(subjectList.size());
        this.nameSpaceMap = new HashMap<String, ApiPojoSubject>(subjectList.size());
        for (PojoSubject subject : subjectList) {
            ApiPojoSubject apiPojoSubject = new ApiPojoSubject(subject.getPojoType());
            apiPojoSubject.init(subject.getPojoType().getAnnotation(ApiPojo.class));
            if (this.nameSpaceMap.containsKey(apiPojoSubject.getNameSpace())) {
                throw new ExistNameSpaceException("\u5df2\u5b58\u5728\u7684nameSpace\uff1a\u4ee3\u7406\u7c7b" + apiPojoSubject.getPojoType().getName() + "[value\uff1a" + apiPojoSubject.getNameSpace() + "]");
            }
            this.initQueryFilter(apiPojoSubject, pojoTableManager.getByPojoType(subject.getPojoType()).getTableInfo().getFieldInfoMap());
            this.apiPojoSubjectMap.put(apiPojoSubject.getPojoType(), apiPojoSubject);
            this.nameSpaceMap.put(apiPojoSubject.getNameSpace(), apiPojoSubject);
        }
        this.checkRepeatedCombination();
    }

    private void checkRepeatedCombination() {
        Map allApiFullPathGroup = this.apiPojoSubjectMap.values().stream().flatMap(s -> s.getEntryInfoList().stream()).collect(Collectors.groupingBy(EntryInfo::getFullPath, Collectors.toList()));
        for (Map.Entry entry : allApiFullPathGroup.entrySet()) {
            if (entry.getValue().size() == 1) continue;
            ApiPojoSubject tempSubject = null;
            HashSet<HttpMethod> methods = new HashSet<HttpMethod>(entry.getValue().size());
            for (EntryInfo entryInfo : entry.getValue()) {
                ApiPojoSubject subject = this.nameSpaceMap.get(entryInfo.getNameSpace());
                if (null == tempSubject) {
                    tempSubject = subject;
                } else if (tempSubject != subject) {
                    throw new SamePathApiException("\u91cd\u590d\u7684api\u6620\u5c04\uff1a\u4ee3\u7406\u7c7b" + subject.getPojoType().getName() + "\t-->\t" + entryInfo.getFullPath() + Arrays.toString(entryInfo.getMethods()));
                }
                for (HttpMethod method : entryInfo.getMethods()) {
                    if (methods.contains(method)) {
                        throw new SamePathApiException("\u91cd\u590d\u7684api\u6620\u5c04\uff1a\u4ee3\u7406\u7c7b" + subject.getPojoType().getName() + "\t-->\t" + entryInfo.getFullPath() + Arrays.toString(entryInfo.getMethods()));
                    }
                    methods.add(method);
                }
            }
        }
    }

    protected void initQueryFilter(ApiPojoSubject apiPojoSubject, Map<String, PojoField> fieldInfoMap) {
        HashMap<String, ApiQueryFilterInfo> apiQueryFilterInfoMap = new HashMap<String, ApiQueryFilterInfo>(fieldInfoMap.size());
        for (Map.Entry<String, PojoField> entry : fieldInfoMap.entrySet()) {
            String key = entry.getKey();
            ApiQueryFilter apiQueryFilter = entry.getValue().getGetter().getAnnotation(ApiQueryFilter.class);
            if (null == apiQueryFilter) continue;
            apiQueryFilterInfoMap.put(key, new ApiQueryFilterInfo(apiQueryFilter));
        }
        if (!apiQueryFilterInfoMap.isEmpty()) {
            apiPojoSubject.setQueryFilterInfoMap(apiQueryFilterInfoMap);
        }
    }

    @Override
    public List<ApiPojoSubject> getApiPojoSubjectList() {
        return Collections.unmodifiableList(new ArrayList<ApiPojoSubject>(this.apiPojoSubjectMap.values()));
    }

    public ApiPojoSubject getByPojoType(Class<?> pojoType) {
        ApiPojoSubject subject = this.apiPojoSubjectMap.get(pojoType);
        if (null == subject) {
            throw new UnKnowPojoException("\u672a\u5b9a\u4e49\u7684apiPojo\u7c7b\u578b\uff1a" + pojoType.getName());
        }
        return subject;
    }

    @Override
    public ApiPojoSubject getByNameSpace(String nameSpace) {
        ApiPojoSubject subject = this.nameSpaceMap.get(nameSpace);
        if (null == subject) {
            throw new UnKnowPojoException("\u672a\u77e5\u7684nameSpace\uff1a" + nameSpace);
        }
        return subject;
    }
}

