/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.api.web.entrust.executor;

import cool.lazy.cat.orm.api.exception.ReflectInvocationException;
import cool.lazy.cat.orm.api.exception.UnKnowTargetApiMethodEntryException;
import cool.lazy.cat.orm.api.web.EntryInfo;
import cool.lazy.cat.orm.api.web.entrust.EntrustApi;
import cool.lazy.cat.orm.api.web.entrust.MethodInfo;
import cool.lazy.cat.orm.api.web.entrust.executor.ApiMethodExecutor;
import cool.lazy.cat.orm.api.web.entrust.executor.intercepter.ApiMethodExecuteInterceptor;
import cool.lazy.cat.orm.api.web.entrust.method.ApiMethodEntry;
import cool.lazy.cat.orm.base.util.CollectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractApiMethodExecutor
implements ApiMethodExecutor {
    protected final Map<Class<? extends ApiMethodEntry>, ApiMethodEntry> apiMethodEntryMap;
    protected final List<ApiMethodExecuteInterceptor> interceptorList = new ArrayList<ApiMethodExecuteInterceptor>();

    protected AbstractApiMethodExecutor(List<ApiMethodEntry> apiMethodEntryList, List<ApiMethodExecuteInterceptor> interceptorList) {
        this.apiMethodEntryMap = apiMethodEntryList.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
        if (CollectionUtil.isNotEmpty(interceptorList)) {
            this.interceptorList.addAll(interceptorList);
        }
    }

    protected Object call(HttpServletRequest request, HttpServletResponse response, EntryInfo entryInfo, ApiMethodEntry methodEntry) {
        this.beforeExecute(request, response, entryInfo, methodEntry);
        EntrustApi apiBean = methodEntry.getApiBean();
        MethodInfo businessMethod = methodEntry.getBusinessMethod();
        Object[] args = methodEntry.buildParameters(request, response);
        this.pendingExecute(request, response, entryInfo, methodEntry, args);
        try {
            Object result = businessMethod.getMethod().invoke((Object)apiBean, args);
            this.afterExecute(request, response, entryInfo, methodEntry, args, result);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectInvocationException("\u53cd\u5c04\u6267\u884c\u4ee3\u7406api\u65b9\u6cd5\u5f02\u5e38", e);
        }
    }

    protected void beforeExecute(HttpServletRequest request, HttpServletResponse response, EntryInfo entryInfo, ApiMethodEntry methodEntry) {
        for (ApiMethodExecuteInterceptor interceptor : this.interceptorList) {
            interceptor.beforeExecute(request, response, entryInfo, methodEntry);
        }
    }

    protected void pendingExecute(HttpServletRequest request, HttpServletResponse response, EntryInfo entryInfo, ApiMethodEntry methodEntry, Object[] args) {
        for (ApiMethodExecuteInterceptor interceptor : this.interceptorList) {
            interceptor.pendingExecute(request, response, entryInfo, methodEntry, args);
        }
    }

    protected void afterExecute(HttpServletRequest request, HttpServletResponse response, EntryInfo entryInfo, ApiMethodEntry methodEntry, Object[] args, Object executeResult) {
        for (ApiMethodExecuteInterceptor interceptor : this.interceptorList) {
            interceptor.afterExecute(request, response, entryInfo, methodEntry, args, executeResult);
        }
    }

    @Override
    public Object execute(HttpServletRequest request, HttpServletResponse response, EntryInfo entryInfo) {
        ApiMethodEntry methodEntry = this.apiMethodEntryMap.get(entryInfo.getApi());
        if (null == methodEntry) {
            throw new UnKnowTargetApiMethodEntryException("\u65e0\u6cd5\u83b7\u53d6api\u65b9\u6cd5, \u8bf7\u68c0\u67e5\u8be5bean\u662f\u5426\u5728IOC\u5bb9\u5668\u4e2d " + entryInfo.getPojoType().getName() + "#" + entryInfo.getApi().getName());
        }
        return this.call(request, response, entryInfo, methodEntry);
    }
}

