/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.api.service.impl;

import cool.lazy.cat.orm.api.manager.ApiPojoManager;
import cool.lazy.cat.orm.api.service.CommonApiService;
import cool.lazy.cat.orm.api.util.ConditionHelper;
import cool.lazy.cat.orm.api.web.FullAutoMappingContext;
import cool.lazy.cat.orm.api.web.bo.QueryInfo;
import cool.lazy.cat.orm.core.base.bo.PageResult;
import cool.lazy.cat.orm.core.base.repository.BaseRepository;
import cool.lazy.cat.orm.core.base.service.impl.AbstractServiceSupport;
import cool.lazy.cat.orm.core.jdbc.Ignorer;
import cool.lazy.cat.orm.core.jdbc.OrderBy;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import cool.lazy.cat.orm.core.jdbc.mapping.field.attr.LogicDeleteField;
import cool.lazy.cat.orm.core.jdbc.param.SearchParam;
import cool.lazy.cat.orm.core.jdbc.param.SearchParamImpl;
import cool.lazy.cat.orm.core.jdbc.sql.condition.Condition;
import cool.lazy.cat.orm.core.jdbc.sql.condition.SqlCondition;
import cool.lazy.cat.orm.core.manager.PojoTableManager;
import java.util.List;

public class CommonApiServiceImpl
extends AbstractServiceSupport
implements CommonApiService {
    protected final BaseRepository baseRepository;
    protected final PojoTableManager pojoTableManager;
    protected final ApiPojoManager apiPojoManager;

    public CommonApiServiceImpl(BaseRepository baseRepository, PojoTableManager pojoTableManager, ApiPojoManager apiPojoManager) {
        this.baseRepository = baseRepository;
        this.pojoTableManager = pojoTableManager;
        this.apiPojoManager = apiPojoManager;
    }

    @Override
    public List<Object> select(QueryInfo queryInfo) {
        return (List)this.getSelectTransactionTemplate(FullAutoMappingContext.getPojoType()).readOnly(s -> this.baseRepository.query(this.convertToParam(queryInfo)));
    }

    @Override
    public PageResult<Object> selectPage(QueryInfo queryInfo) {
        return (PageResult)this.getSelectTransactionTemplate(FullAutoMappingContext.getPojoType()).readOnly(s -> this.baseRepository.queryPage(this.convertToParam(queryInfo)));
    }

    protected Condition initCondition(Class<?> pojoType) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        if (null != tableInfo.getLogicDeleteField()) {
            LogicDeleteField logicDeleteField = tableInfo.getLogicDeleteField();
            return Condition.eq((String)logicDeleteField.getJavaFieldName(), (Object)logicDeleteField.getNormalValue());
        }
        return null;
    }

    protected SearchParam<Object> convertToParam(QueryInfo queryInfo) {
        Class<?> pojoType = FullAutoMappingContext.getPojoType();
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        SearchParamImpl searchParam = new SearchParamImpl(tableInfo);
        searchParam.setIndex(queryInfo.getStartIndex());
        searchParam.setPageSize(queryInfo.getPageSize());
        searchParam.setOrderBy(OrderBy.buildOrderBy((boolean)queryInfo.isAsc(), (String[])queryInfo.getOrderFields()));
        searchParam.setIgnorer(Ignorer.build((String[])queryInfo.getIgnoreFields()));
        Condition condition = this.initCondition(pojoType);
        SqlCondition sqlCondition = ConditionHelper.convert(pojoType, this.apiPojoManager, queryInfo.getParams());
        if (null != condition) {
            searchParam.setCondition((SqlCondition)condition.and(sqlCondition));
        } else {
            searchParam.setCondition(sqlCondition);
        }
        return searchParam;
    }
}

