/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web.jackson2.serializer;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import cool.happycoding.code.base.util.DateUtils;
import java.io.IOException;
import java.util.Date;

public class Jackson2DateSerializer
extends JsonSerializer<Date> {
    private final String dateFormat;

    public Jackson2DateSerializer(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (ObjectUtil.isNotNull((Object)date)) {
            jsonGenerator.writeString(DateUtils.format((Date)date, (String)this.dateFormat));
        }
    }

    public Class<Date> handledType() {
        return Date.class;
    }
}

