/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.validator.annotation;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import cool.happycoding.code.validator.annotation.Birthday;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class BirthdayValidator
implements ConstraintValidator<Birthday, Object> {
    private boolean notNull;

    public void initialize(Birthday constraintAnnotation) {
        this.notNull = constraintAnnotation.notNull();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        String validValue = null;
        if (value instanceof String) {
            validValue = (String)value;
        } else if (value instanceof Date) {
            validValue = DateUtil.formatDate((Date)((Date)value));
        } else if (value instanceof TemporalAccessor) {
            validValue = DateTimeFormatter.ofPattern("yyyy-MM-dd").format((TemporalAccessor)value);
        }
        if (StrUtil.isNotBlank((CharSequence)validValue)) {
            return Validator.isBirthday((CharSequence)validValue);
        }
        return !this.notNull;
    }
}

