/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.validator;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cool.happycoding.code.base.common.HappyStatus;
import cool.happycoding.code.base.exception.BizException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorEnhance {
    private static final Logger log = LoggerFactory.getLogger(ValidatorEnhance.class);
    private Object param;
    private final Validator validator;
    private static final String NOT_NULL_HINT_MSG = "\u53c2\u6570 {} \u5fc5\u987b\u4e0d\u4e3a null";
    private static final String NOT_EMPTY_HINT_MSG = "\u53c2\u6570 {} \u5fc5\u987b\u4e0d\u4e3aempty(null \u6216 \"\")";
    private static final String ASSERT_TRUE_HINT_MSG = "\u53c2\u6570 {} \u5fc5\u987b\u4e3a true";
    private static final String ASSERT_FALSE_HINT_MSG = "\u53c2\u6570 {} \u5fc5\u987b\u4e3a false";
    private static final String DIGITS_HINT_MSG = "\u53c2\u6570 {} \u5fc5\u987b\u662f\u4e00\u4e2a\u6570\u5b57\uff0c\u5176\u503c\u5fc5\u987b\u5728 {} - {} \u4e4b\u95f4\uff08\u5305\u542b\uff09";
    private static final String MAX_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u80fd\u8d85\u8fc7\u6700\u5927\u503c\uff1a{}";
    private static final String MIN_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u80fd\u4f4e\u4e8e\u6700\u5c0f\u503c\uff1a{}";
    private static final String LENGTH_HINT_MSG = "\u53c2\u6570 {} \u957f\u5ea6\u5fc5\u987b\u5728 {} - {} \u4e4b\u95f4\uff08\u5305\u542b\uff09";
    private static final String CHINESE_HINT_MSG = "\u53c2\u6570 {} \u4e2d\u6587\u6821\u9a8c\u4e0d\u901a\u8fc7";
    private static final String ENGLISH_HINT_MSG = "\u53c2\u6570 {} \u82f1\u6587\u6821\u9a8c\u4e0d\u901a\u8fc7";
    private static final String BIRTHDAY_HINT_MSG = "\u53c2\u6570 {} \u751f\u65e5\u6821\u9a8c\u4e0d\u901a\u8fc7";
    private static final String CELLPHONE_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u624b\u673a\u53f7\u7801";
    private static final String EMAIL_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u90ae\u7bb1\u683c\u5f0f";
    private static final String ID_CARD_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u8eab\u4efd\u8bc1\u53f7\u7801";
    private static final String PLATE_NUMBER_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u4e2d\u56fd\u8f66\u724c\u53f7\u7801";
    private static final String UUID_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684UUID";
    private static final String URL_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684URL";
    private static final String IPV4_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684IPV4\u5730\u5740";
    private static final String IPV6_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684IPV6\u5730\u5740";
    private static final String MAC_ADDRESS_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684MAC\u5730\u5740";
    private static final String REGEX_HINT_MSG = "\u53c2\u6570 {} \u4e0d\u6ee1\u8db3\u6b63\u5219\u8868\u8fbe\u5f0f\uff1a{}";

    public ValidatorEnhance(Validator validator) {
        this.validator = validator;
    }

    public ValidatorEnhance param(Object param) {
        this.param = param;
        return this;
    }

    public ValidatorEnhance notNull(String paramName) {
        cn.hutool.core.lang.Validator.validateNotNull((Object)this.param, (String)StrUtil.format((CharSequence)NOT_NULL_HINT_MSG, (Object[])new Object[]{paramName}), (Object[])new Object[0]);
        return this;
    }

    public ValidatorEnhance notEmpty(String paramName) {
        cn.hutool.core.lang.Validator.validateNotEmpty((Object)this.param, (String)StrUtil.format((CharSequence)NOT_EMPTY_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance assertTrue(String paramName) {
        cn.hutool.core.lang.Validator.validateTrue((boolean)((Boolean)this.param), (String)StrUtil.format((CharSequence)ASSERT_TRUE_HINT_MSG, (Object[])new Object[]{paramName}), (Object[])new Object[0]);
        return this;
    }

    public ValidatorEnhance assertFalse(String paramName) {
        cn.hutool.core.lang.Validator.validateFalse((boolean)((Boolean)this.param), (String)StrUtil.format((CharSequence)ASSERT_FALSE_HINT_MSG, (Object[])new Object[]{paramName}), (Object[])new Object[0]);
        return this;
    }

    public ValidatorEnhance digits(Number min, Number max, String paramName) {
        cn.hutool.core.lang.Validator.validateBetween((Number)((Number)this.param), (Number)min, (Number)max, (String)StrUtil.format((CharSequence)DIGITS_HINT_MSG, (Object[])new Object[]{paramName, min, max}));
        return this;
    }

    public ValidatorEnhance max(Number max, String paramName) {
        BigDecimal bigNum2;
        BigDecimal bigNum1 = NumberUtil.toBigDecimal((Number)((Number)this.param));
        if (!NumberUtil.isLessOrEqual((BigDecimal)bigNum1, (BigDecimal)(bigNum2 = NumberUtil.toBigDecimal((Number)max)))) {
            throw new ValidateException(StrUtil.format((CharSequence)MAX_HINT_MSG, (Object[])new Object[]{paramName, max}));
        }
        return this;
    }

    public ValidatorEnhance min(Number min, String paramName) {
        BigDecimal bigNum2;
        BigDecimal bigNum1 = NumberUtil.toBigDecimal((Number)((Number)this.param));
        if (!NumberUtil.isGreaterOrEqual((BigDecimal)bigNum1, (BigDecimal)(bigNum2 = NumberUtil.toBigDecimal((Number)min)))) {
            throw new ValidateException(StrUtil.format((CharSequence)MIN_HINT_MSG, (Object[])new Object[]{paramName, min}));
        }
        return this;
    }

    public ValidatorEnhance length(int min, int max, String paramName) {
        int length = ObjectUtil.length((Object)this.param);
        if (length < min || length > max) {
            throw new ValidateException(StrUtil.format((CharSequence)LENGTH_HINT_MSG, (Object[])new Object[]{paramName, min, max}));
        }
        return this;
    }

    public ValidatorEnhance chinese(String paramName) {
        cn.hutool.core.lang.Validator.validateChinese((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)CHINESE_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance english(String paramName) {
        cn.hutool.core.lang.Validator.validateWord((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)ENGLISH_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance birthday(String paramName) {
        String date = null;
        if (this.param instanceof String) {
            date = (String)this.param;
        } else if (this.param instanceof Date) {
            date = DateUtil.formatDate((Date)((Date)this.param));
        } else if (this.param instanceof LocalDate || this.param instanceof LocalDateTime) {
            date = DateTimeFormatter.ofPattern("yyyy-MM-dd").format((LocalDate)this.param);
        } else {
            throw new BizException(HappyStatus.REQUEST_VALIDATION_FAILED.getCode(), StrUtil.format((CharSequence)"\u53c2\u6570 {} \u672a\u77e5\u7c7b\u578b\uff0c\u4e0d\u652f\u6301\u751f\u65e5\u6821\u9a8c", (Object[])new Object[]{paramName}));
        }
        cn.hutool.core.lang.Validator.validateBirthday((CharSequence)date, (String)StrUtil.format((CharSequence)BIRTHDAY_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance cellphone(String paramName) {
        cn.hutool.core.lang.Validator.validateMobile((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)CELLPHONE_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance email(String paramName) {
        cn.hutool.core.lang.Validator.validateEmail((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)EMAIL_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance idCard(String paramName) {
        cn.hutool.core.lang.Validator.validateCitizenIdNumber((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)ID_CARD_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance plateNumber(String paramName) {
        cn.hutool.core.lang.Validator.validatePlateNumber((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)PLATE_NUMBER_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance uuid(String paramName) {
        cn.hutool.core.lang.Validator.validateUUID((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)UUID_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance url(String paramName) {
        cn.hutool.core.lang.Validator.validateUrl((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)URL_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance ipv4(String paramName) {
        cn.hutool.core.lang.Validator.validateIpv4((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)IPV4_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance ipv6(String paramName) {
        cn.hutool.core.lang.Validator.validateIpv6((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)IPV6_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance macAddress(String paramName) {
        cn.hutool.core.lang.Validator.validateMac((CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)MAC_ADDRESS_HINT_MSG, (Object[])new Object[]{paramName}));
        return this;
    }

    public ValidatorEnhance regex(String regex, String paramName) {
        cn.hutool.core.lang.Validator.validateMatchRegex((String)regex, (CharSequence)((CharSequence)this.param), (String)StrUtil.format((CharSequence)REGEX_HINT_MSG, (Object[])new Object[]{paramName, regex}));
        return this;
    }

    public ValidatorEnhance valid(Object param) {
        Set violations = this.validator.validate(param, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        return this;
    }
}

