/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.validator;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.google.common.collect.Maps;
import cool.happycoding.code.validator.ValidatorEnhance;
import cool.happycoding.code.validator.ValidatorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
@AutoConfigureBefore(value={ValidationAutoConfiguration.class})
@EnableConfigurationProperties(value={ValidatorProperties.class})
public class HappyValidatorAutoConfiguration {
    private final ValidatorProperties validatorProperties;

    public HappyValidatorAutoConfiguration(ValidatorProperties validatorProperties) {
        this.validatorProperties = validatorProperties;
    }

    @Bean
    @Primary
    public LocalValidatorFactoryBean defaultValidator() {
        LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();
        localValidatorFactoryBean.setProviderClass(HibernateValidator.class);
        HashMap validationProperties = Maps.newHashMap();
        if (ObjectUtil.isNotNull((Object)this.validatorProperties.getFailFast())) {
            validationProperties.put("hibernate.validator.fail_fast", this.validatorProperties.getFailFast().toString());
        }
        if (CollUtil.isNotEmpty((Map)validationProperties)) {
            localValidatorFactoryBean.setValidationPropertyMap((Map)validationProperties);
        }
        return localValidatorFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public ValidatorEnhance validatorEnhance() {
        return new ValidatorEnhance((Validator)this.defaultValidator());
    }
}

