/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.user;

import cool.happycoding.code.base.user.UserContextService;
import cool.happycoding.code.user.DefaultUserContextService;
import cool.happycoding.code.user.UserContextMethodArgumentResolver;
import cool.happycoding.code.user.UserContextProperties;
import cool.happycoding.code.user.UserInnerFilter;
import cool.happycoding.code.user.context.UserContextLoadInnerFilter;
import cool.happycoding.code.user.filter.UserContextLoadFilter;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={UserContextProperties.class})
public class HappyUserAutoConfiguration
implements WebMvcConfigurer {
    @Bean
    @ConditionalOnMissingBean
    public UserContextService userContextService(UserContextProperties userContextProperties) {
        return new DefaultUserContextService(userContextProperties);
    }

    @Bean
    public UserInnerFilter userInnerFilter(UserContextService userContextService, UserContextProperties userContextProperties) {
        return new UserContextLoadInnerFilter(userContextService, userContextProperties);
    }

    @Bean
    public FilterRegistrationBean<UserContextLoadFilter> filterRegistrationBean(ObjectProvider<List<UserInnerFilter>> userInnerFilterProvider, UserContextService userContextService, UserContextProperties userContextProperties) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        List userInnerFilters = (List)userInnerFilterProvider.getIfAvailable();
        if (userInnerFilters != null) {
            OrderComparator.sort((List)userInnerFilters);
        }
        registrationBean.setFilter((Filter)new UserContextLoadFilter(userInnerFilters));
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName("userContextLoadFilter");
        registrationBean.setOrder(userContextProperties.getFilterOrder());
        return registrationBean;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new UserContextMethodArgumentResolver());
    }
}

