/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.stream.mq.sample.produce;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cool.happycoding.code.base.result.BaseResult;
import cool.happycoding.code.stream.mq.sample.UserBean;
import cool.happycoding.code.stream.mq.sample.produce.ProducerResource;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"stream-producer"})
public class ProducerController {
    private static final Logger log = LoggerFactory.getLogger(ProducerController.class);
    private final ProducerResource producer;

    @PostMapping(value={"output"})
    @ApiOperation(value="stream-output")
    public BaseResult<UserBean> output(@RequestBody UserBean userBean) {
        userBean.setBirthday((Date)DateUtil.date());
        userBean.setUserId(IdUtil.simpleUUID());
        userBean.setSalary(BigDecimal.valueOf(9527.22));
        this.producer.output().send(MessageBuilder.withPayload((Object)userBean).build());
        return BaseResult.success((Object)userBean);
    }

    public ProducerController(ProducerResource producer) {
        this.producer = producer;
    }
}

