/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.sentinel;

import cn.hutool.json.JSONUtil;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.BlockRequestHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import cool.happycoding.code.base.result.Result;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;

@Configuration
public class HappySentinelAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={HttpServletRequest.class})
    public BlockExceptionHandler webmvcBlockExceptionHandler() {
        return (request, response, e) -> {
            response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            Result result = Result.failure((String)String.valueOf(HttpStatus.TOO_MANY_REQUESTS.value()), (String)e.getMessage());
            response.getWriter().print(JSONUtil.toJsonStr((Object)result));
        };
    }

    @Bean
    @ConditionalOnClass(value={ServerResponse.class})
    public BlockRequestHandler webfluxBlockExceptionHandler() {
        return (exchange, t) -> ServerResponse.status((HttpStatus)HttpStatus.TOO_MANY_REQUESTS).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)Result.failure((String)String.valueOf(HttpStatus.TOO_MANY_REQUESTS.value()), (String)t.getMessage())));
    }
}

