/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.mybatis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import cool.happycoding.code.mybatis.HappyMybatisProperties;
import cool.happycoding.code.user.context.UserContextHolder;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;

public class HappyTenantLineHandler
implements TenantLineHandler {
    private final HappyMybatisProperties happyMybatisProperties;

    public HappyTenantLineHandler(HappyMybatisProperties happyMybatisProperties) {
        this.happyMybatisProperties = happyMybatisProperties;
    }

    public Expression getTenantId() {
        return new StringValue(UserContextHolder.getUser().tenantId());
    }

    public String getTenantIdColumn() {
        return StrUtil.blankToDefault((CharSequence)this.happyMybatisProperties.getTenantIdColumn(), (String)"tenant_id");
    }

    public boolean ignoreTable(String tableName) {
        if (CollUtil.isNotEmpty(this.happyMybatisProperties.getIgnoreTables())) {
            return this.happyMybatisProperties.getIgnoreTables().contains(tableName);
        }
        return false;
    }
}

