/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.mybatis;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import cool.happycoding.code.mybatis.AutoFieldFillHandler;
import cool.happycoding.code.mybatis.DefaultAutoFieldFillHandler;
import cool.happycoding.code.mybatis.HappyMybatisMetaObjectHandler;
import cool.happycoding.code.mybatis.HappyMybatisProperties;
import cool.happycoding.code.mybatis.HappyTenantLineHandler;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;

@Configuration
@PropertySource(value={"classpath:happy-mybatis.properties"})
@EnableConfigurationProperties(value={HappyMybatisProperties.class})
public class HappyMybatisAutoConfiguration {
    private final HappyMybatisProperties happyMybatisProperties;

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(ObjectProvider<List<InnerInterceptor>> interceptorProvider) {
        MybatisPlusInterceptor mybatisPlusInterceptor = new MybatisPlusInterceptor();
        List interceptors = (List)interceptorProvider.getIfAvailable();
        if (interceptors != null) {
            AnnotationAwareOrderComparator.sort((List)interceptors);
        }
        mybatisPlusInterceptor.setInterceptors(interceptors);
        return mybatisPlusInterceptor;
    }

    @Bean
    @Order(value=999)
    public PaginationInnerInterceptor paginationInnerInterceptor() {
        PaginationInnerInterceptor paginationInterceptor = new PaginationInnerInterceptor();
        paginationInterceptor.setOverflow(this.happyMybatisProperties.isOverflow());
        paginationInterceptor.setMaxLimit(Long.valueOf(this.happyMybatisProperties.getLimit()));
        return paginationInterceptor;
    }

    @Bean
    @Order(value=1)
    @ConditionalOnProperty(name={"happy.code.mybatis.enable-block-attack"}, havingValue="true")
    public BlockAttackInnerInterceptor blockAttackInnerInterceptor() {
        return new BlockAttackInnerInterceptor();
    }

    @Bean
    @Order(value=10)
    @ConditionalOnProperty(name={"happy.code.mybatis.enable-version"}, havingValue="true")
    public OptimisticLockerInnerInterceptor optimisticLockerInnerInterceptor() {
        return new OptimisticLockerInnerInterceptor();
    }

    @Bean
    @Order(value=22)
    @ConditionalOnProperty(name={"happy.code.mybatis.enable-tenant"}, havingValue="true")
    public TenantLineInnerInterceptor tenantLineInnerInterceptor() {
        TenantLineInnerInterceptor tenantLineInnerInterceptor = new TenantLineInnerInterceptor();
        tenantLineInnerInterceptor.setTenantLineHandler((TenantLineHandler)new HappyTenantLineHandler(this.happyMybatisProperties));
        return tenantLineInnerInterceptor;
    }

    @Bean
    public MybatisPlusPropertiesCustomizer mybatisPlusPropertiesCustomizer(HappyMybatisProperties happyMybatisProperties) {
        return properties -> {
            properties.getGlobalConfig().setBanner(Boolean.FALSE.booleanValue());
            properties.getGlobalConfig().getDbConfig().setIdType(happyMybatisProperties.getIdType());
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public AutoFieldFillHandler autoFieldFillHandler() {
        return new DefaultAutoFieldFillHandler();
    }

    @Bean
    public MetaObjectHandler metaObjectHandler(AutoFieldFillHandler autoFieldFillHandler) {
        return new HappyMybatisMetaObjectHandler(autoFieldFillHandler);
    }

    public HappyMybatisAutoConfiguration(HappyMybatisProperties happyMybatisProperties) {
        this.happyMybatisProperties = happyMybatisProperties;
    }
}

