/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.mybatis;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.google.common.collect.Lists;
import cool.happycoding.code.mybatis.AutoFieldFillHandler;
import cool.happycoding.code.mybatis.DefaultAutoFieldFillHandler;
import cool.happycoding.code.mybatis.HappyMybatisMetaObjectHandler;
import cool.happycoding.code.mybatis.HappyMybatisProperties;
import cool.happycoding.code.mybatis.InnerInterceptorHolder;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:happy-mybatis.properties"})
@EnableConfigurationProperties(value={HappyMybatisProperties.class})
public class HappyMybatisAutoConfiguration {
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(HappyMybatisProperties happyMybatisProperties) {
        MybatisPlusInterceptor mybatisPlusInterceptor = new MybatisPlusInterceptor();
        ArrayList interceptors = Lists.newArrayList();
        if (happyMybatisProperties.isEnableBlockAttack()) {
            interceptors.add(InnerInterceptorHolder.blockAttackInnerInterceptor());
        }
        interceptors.add(InnerInterceptorHolder.paginationInnerInterceptor(happyMybatisProperties));
        mybatisPlusInterceptor.setInterceptors((List)interceptors);
        return mybatisPlusInterceptor;
    }

    @Bean
    public MybatisPlusPropertiesCustomizer mybatisPlusPropertiesCustomizer(HappyMybatisProperties happyMybatisProperties) {
        return properties -> {
            properties.getGlobalConfig().setBanner(Boolean.FALSE.booleanValue());
            properties.getGlobalConfig().getDbConfig().setIdType(happyMybatisProperties.getIdType());
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public AutoFieldFillHandler autoFieldFillHandler() {
        return new DefaultAutoFieldFillHandler();
    }

    @Bean
    public MetaObjectHandler metaObjectHandler(AutoFieldFillHandler autoFieldFillHandler) {
        return new HappyMybatisMetaObjectHandler(autoFieldFillHandler);
    }
}

