/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.mq.sample.rest;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cool.happycoding.code.base.result.BaseResult;
import cool.happycoding.code.mq.sample.domain.Order;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"transaction-producer"})
public class TransactionMessageProducerController {
    private static final Logger log = LoggerFactory.getLogger(TransactionMessageProducerController.class);
    private final RocketMQTemplate rocketMQTemplate;

    @PostMapping(value={"transaction-order"})
    @ApiOperation(value="\u4e8b\u52a1\u6d88\u606f")
    public BaseResult<?> transactionOrder(@RequestBody Order order) {
        order.setOrderDate((Date)DateUtil.date());
        order.setOrderId(IdUtil.simpleUUID());
        this.rocketMQTemplate.sendMessageInTransaction("transaction-topic:tx", MessageBuilder.withPayload((Object)order).build(), (Object)order.getOrderId());
        return BaseResult.success((Object)order);
    }

    public TransactionMessageProducerController(RocketMQTemplate rocketMQTemplate) {
        this.rocketMQTemplate = rocketMQTemplate;
    }
}

