/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.mq.sample.rest;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cool.happycoding.code.base.result.BaseResult;
import cool.happycoding.code.mq.sample.domain.Order;
import cool.happycoding.code.mq.sample.domain.OrderReply;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"simple-producer"})
public class SimpleMessageProducerController {
    private static final Logger log = LoggerFactory.getLogger(SimpleMessageProducerController.class);
    private final RocketMQTemplate rocketMQTemplate;

    @PostMapping(value={"sync-order"})
    @ApiOperation(value="\u666e\u901a\u6d88\u606f-\u540c\u6b65\u6d88\u606f")
    public BaseResult<Order> syncOrder(@RequestBody Order order) {
        order.setOrderDate((Date)DateUtil.date());
        order.setOrderId(IdUtil.simpleUUID());
        this.rocketMQTemplate.convertAndSend((Object)"simple-topic:simple", (Object)order, message -> {
            log.info("headers:{}, message:{}", (Object)message.getHeaders(), message.getPayload().getClass());
            return message;
        });
        return BaseResult.success((Object)order);
    }

    @PostMapping(value={"async-order"})
    @ApiOperation(value="\u666e\u901a\u6d88\u606f-\u5f02\u6b65\u6d88\u606f")
    public BaseResult<Order> asyncOrder(@RequestBody Order order) {
        order.setOrderDate((Date)DateUtil.date());
        order.setOrderId(IdUtil.simpleUUID());
        this.rocketMQTemplate.asyncSend("simple-topic:simple", (Object)order, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                log.info("success:{}", (Object)sendResult);
            }

            public void onException(Throwable e) {
                log.error("error message:{}", (Object)e.getMessage());
            }
        });
        return BaseResult.success((Object)order);
    }

    @PostMapping(value={"sync-order-reply"})
    @ApiOperation(value="\u666e\u901a\u6d88\u606f-\u540c\u6b65\u6d88\u606f-\u643a\u5e26\u8fd4\u56de\u503c")
    public BaseResult<OrderReply> syncOrderReply(@RequestBody Order order) {
        order.setOrderDate((Date)DateUtil.date());
        order.setOrderId(IdUtil.simpleUUID());
        OrderReply orderReply = (OrderReply)this.rocketMQTemplate.sendAndReceive("simple-topic:reply", (Object)order, OrderReply.class);
        return BaseResult.success((Object)orderReply);
    }

    @PostMapping(value={"one-way-order"})
    @ApiOperation(value="\u666e\u901a\u6d88\u606f-\u5355\u5411\u6d88\u606f")
    public BaseResult<Order> oneWayOrder(@RequestBody Order order) {
        order.setOrderDate((Date)DateUtil.date());
        order.setOrderId(IdUtil.simpleUUID());
        this.rocketMQTemplate.sendOneWay("simple-topic:simple", MessageBuilder.withPayload((Object)order).setHeader("one-way", (Object)"\u5355\u5411\u6d88\u606f").build());
        return BaseResult.success((Object)order);
    }

    @PostMapping(value={"broadcast-order"})
    @ApiOperation(value="\u666e\u901a\u6d88\u606f-\u5e7f\u64ad\u6d88\u606f")
    public BaseResult<Order> broadcastOrder(@RequestBody Order order) {
        order.setOrderDate((Date)DateUtil.date());
        order.setOrderId(IdUtil.simpleUUID());
        this.rocketMQTemplate.convertAndSend((Object)"broadcast-topic:broadcast", (Object)order, message -> {
            log.info("headers:{}, message:{}", (Object)message.getHeaders(), message.getPayload().getClass());
            return message;
        });
        return BaseResult.success((Object)order);
    }

    public SimpleMessageProducerController(RocketMQTemplate rocketMQTemplate) {
        this.rocketMQTemplate = rocketMQTemplate;
    }
}

