/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.mq.sample.rest;

import cn.hutool.core.date.DateUtil;
import cool.happycoding.code.base.result.BaseResult;
import cool.happycoding.code.mq.sample.domain.Order;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"order-producer"})
public class OrderMessageProducerController {
    private static final Logger log = LoggerFactory.getLogger(OrderMessageProducerController.class);
    private final RocketMQTemplate rocketMQTemplate;

    @PostMapping(value={"sync-order-message"})
    @ApiOperation(value="\u987a\u5e8f\u6d88\u606f-\u540c\u6b65")
    public BaseResult<?> order(@RequestBody Order order) {
        for (int i = 0; i < 7; ++i) {
            order.setOrderDate((Date)DateUtil.date());
            order.setOrderId(i + "");
            this.rocketMQTemplate.syncSendOrderly("order-topic:order", (Object)order, order.getOrderId());
        }
        return BaseResult.success();
    }

    public OrderMessageProducerController(RocketMQTemplate rocketMQTemplate) {
        this.rocketMQTemplate = rocketMQTemplate;
    }
}

