/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.lock;

import cn.hutool.core.util.ObjectUtil;
import cool.happycoding.code.lock.HappyDistributedLock;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HappyRedissonDistributedLock
implements HappyDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(HappyRedissonDistributedLock.class);
    private final RedissonClient redisson;

    public HappyRedissonDistributedLock(RedissonClient redisson) {
        this.redisson = redisson;
    }

    @Override
    public Boolean lock(String key, Integer leaseTime, TimeUnit timeUnit, Boolean fairLock) {
        try {
            RLock lock = this.getLock(key, fairLock);
            lock.lock((long)leaseTime.intValue(), timeUnit);
            log.debug("-------->[{}]\u83b7\u53d6\u5230\u9501\u3002", (Object)key);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9501\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            log.debug("-------->[{}]\u672a\u83b7\u53d6\u5230\u9501\u3002", (Object)key);
            return Boolean.FALSE;
        }
    }

    @Override
    public Boolean tryLock(String key, Integer waitTime, Integer leaseTime, TimeUnit timeUnit, Boolean fairLock) {
        RLock lock = this.getLock(key, fairLock);
        try {
            boolean flag = lock.tryLock((long)waitTime.intValue(), (long)leaseTime.intValue(), timeUnit);
            log.debug("-------->tryLock[{}] {}\u5230\u9501\u3002", (Object)key, (Object)(flag ? "\u83b7\u53d6" : "\u672a\u83b7\u53d6"));
            return flag;
        }
        catch (Exception e) {
            log.error("\u5c1d\u8bd5\u9501\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean isLock(String key) {
        RLock lock = this.getLock(key, false);
        Boolean flag = lock.isLocked();
        log.debug("-------->\u68c0\u6d4b\u5230key[{}]" + (flag != false ? "\u5df2" : "\u672a") + "\u4e0a\u9501", (Object)key);
        return flag;
    }

    @Override
    public void unlock(String key) {
        RLock lock = this.getLock(key, false);
        if (ObjectUtil.isNotNull((Object)lock) && this.isLock(key).booleanValue()) {
            log.debug("-------->[{}]\u89e3\u9501", (Object)key);
            lock.unlock();
        }
    }

    public RLock getLock(String key, Boolean fairLock) {
        return fairLock != false ? this.redisson.getFairLock(this.distributeKeyWrapper(key)) : this.redisson.getLock(this.distributeKeyWrapper(key));
    }
}

