/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.lock;

import cool.happycoding.code.lock.HappyDistributedLock;
import cool.happycoding.code.lock.HappyDistributedLockAspect;
import cool.happycoding.code.lock.HappyRedissonDistributedLock;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Redisson.class, RedissonClient.class})
@AutoConfigureAfter(value={RedissonAutoConfiguration.class})
public class HappyLockAutoConfiguration {
    private final RedissonClient redisson;

    @Bean
    public HappyDistributedLock distributedLock() {
        return new HappyRedissonDistributedLock(this.redisson);
    }

    @Bean
    public HappyDistributedLockAspect happyDistributedLockAspect() {
        return new HappyDistributedLockAspect(this.distributedLock());
    }

    public HappyLockAutoConfiguration(RedissonClient redisson) {
        this.redisson = redisson;
    }
}

