/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.lock;

import cn.hutool.core.util.StrUtil;
import cool.happycoding.code.lock.HLock;
import cool.happycoding.code.lock.HappyDistributedLock;
import cool.happycoding.code.lock.HappyLockException;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class HappyDistributedLockAspect {
    private final HappyDistributedLock happyDistributedLock;
    private final SpelExpressionParser spelExpressionParser;
    private final DefaultParameterNameDiscoverer nameDiscoverer;

    public HappyDistributedLockAspect(HappyDistributedLock happyDistributedLock) {
        this.happyDistributedLock = happyDistributedLock;
        this.spelExpressionParser = new SpelExpressionParser();
        this.nameDiscoverer = new DefaultParameterNameDiscoverer();
    }

    @Around(value="@annotation(cool.happycoding.code.lock.HLock)")
    public Object invoke(ProceedingJoinPoint joinPoint, HLock hLock) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String key = this.getKey(joinPoint, methodSignature, hLock);
        boolean lock = hLock.tryLock() ? this.happyDistributedLock.tryLock(key, hLock.waitTime(), hLock.leaseTime(), hLock.timeUnit(), hLock.fairLock()) : this.happyDistributedLock.lock(key, hLock.leaseTime(), hLock.timeUnit(), hLock.fairLock());
        try {
            if (lock) {
                Object object = joinPoint.proceed();
                return object;
            }
            if (hLock.throwException()) {
                throw new HappyLockException("Acquire distribute lock fail");
            }
            Object var6_7 = null;
            return var6_7;
        }
        catch (Throwable throwable) {
            throw new HappyLockException(throwable.getMessage());
        }
        finally {
            this.happyDistributedLock.unlock(key);
        }
    }

    private String getKey(ProceedingJoinPoint joinPoint, MethodSignature methodSignature, HLock hLock) {
        String key = hLock.key();
        String lockKey = null;
        if (StrUtil.startWith((CharSequence)key, (CharSequence)"#")) {
            Object[] args = joinPoint.getArgs();
            lockKey = this.getKeyBySpEl(key, methodSignature, args);
        }
        if (StrUtil.isBlank(lockKey)) {
            lockKey = StrUtil.concat((boolean)false, (CharSequence[])new CharSequence[]{joinPoint.getTarget().getClass().getName(), ":", methodSignature.getMethod().getName()});
        }
        return lockKey;
    }

    private String getKeyBySpEl(String spEL, MethodSignature methodSignature, Object[] args) {
        String[] paramNames = this.nameDiscoverer.getParameterNames(methodSignature.getMethod());
        if (paramNames != null && paramNames.length > 0) {
            Expression expression = this.spelExpressionParser.parseExpression(spEL);
            StandardEvaluationContext context = new StandardEvaluationContext();
            for (int i = 0; i < args.length; ++i) {
                context.setVariable(paramNames[i], args[i]);
            }
            if (!Objects.isNull(expression.getValue((EvaluationContext)context))) {
                return Objects.requireNonNull(expression.getValue((EvaluationContext)context)).toString();
            }
        }
        return null;
    }
}

