/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.cache;

import cn.hutool.system.SystemUtil;
import com.alibaba.fastjson.JSON;
import com.alicp.jetcache.support.CacheMessage;
import com.alicp.jetcache.support.CacheMessagePublisher;
import cool.happycoding.code.cache.HappyCacheProperties;
import cool.happycoding.code.cache.SyncCacheMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SyncRedisCacheMessagePublisher
implements CacheMessagePublisher {
    private static final Logger log = LoggerFactory.getLogger(SyncRedisCacheMessagePublisher.class);
    private final HappyCacheProperties happyCacheProperties;
    private final StringRedisTemplate stringRedisTemplate;

    public SyncRedisCacheMessagePublisher(HappyCacheProperties happyCacheProperties, StringRedisTemplate stringRedisTemplate) {
        this.happyCacheProperties = happyCacheProperties;
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void publish(String area, String cacheName, CacheMessage cacheMessage) {
        log.info("cache remove area: {}, cacheName: {}, message: {}", new Object[]{area, cacheName, JSON.toJSONString((Object)cacheMessage)});
        this.stringRedisTemplate.convertAndSend(this.happyCacheProperties.getBothCacheSyncTopic(), (Object)SyncCacheMessage.builder().area(area).cacheName(cacheName).timestamp(System.currentTimeMillis()).producerAddr(SystemUtil.getHostInfo().getAddress()).cacheMessage(cacheMessage).build().toJSONString());
    }
}

