/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.cache;

import com.alicp.jetcache.anno.support.SpringConfigProvider;
import com.alicp.jetcache.autoconfigure.JetCacheAutoConfiguration;
import com.alicp.jetcache.support.CacheMessagePublisher;
import cool.happycoding.code.cache.HappyCacheProperties;
import cool.happycoding.code.cache.NoneSyncCachePostProcessor;
import cool.happycoding.code.cache.SyncCachePostProcessor;
import cool.happycoding.code.cache.SyncRedisCacheMessageListener;
import cool.happycoding.code.cache.SyncRedisCacheMessagePublisher;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@Configuration
@EnableConfigurationProperties(value={HappyCacheProperties.class})
@PropertySource(value={"classpath:happy-jetcache.properties"})
@AutoConfigureBefore(value={JetCacheAutoConfiguration.class})
public class HappyCacheAutoConfiguration {
    private final HappyCacheProperties happyCacheProperties;
    private final StringRedisTemplate stringRedisTemplate;
    private final RedisConnectionFactory redisConnectionFactory;

    @Bean
    public CacheMessagePublisher cacheMessagePublisher() {
        return new SyncRedisCacheMessagePublisher(this.happyCacheProperties, this.stringRedisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public SyncCachePostProcessor syncCachePostProcessor() {
        return new NoneSyncCachePostProcessor();
    }

    @Bean
    public ChannelTopic channelTopic() {
        return new ChannelTopic(this.happyCacheProperties.getBothCacheSyncTopic());
    }

    @Bean
    public RedisMessageListenerContainer redisMessageListenerContainer(SpringConfigProvider springConfigProvider, SyncCachePostProcessor syncCachePostProcessor) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(this.redisConnectionFactory);
        redisMessageListenerContainer.addMessageListener((MessageListener)new SyncRedisCacheMessageListener(springConfigProvider, syncCachePostProcessor, this.stringRedisTemplate), (Topic)this.channelTopic());
        return redisMessageListenerContainer;
    }

    public HappyCacheAutoConfiguration(HappyCacheProperties happyCacheProperties, StringRedisTemplate stringRedisTemplate, RedisConnectionFactory redisConnectionFactory) {
        this.happyCacheProperties = happyCacheProperties;
        this.stringRedisTemplate = stringRedisTemplate;
        this.redisConnectionFactory = redisConnectionFactory;
    }
}

