/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.generator.output;

import cool.doudou.mybatis.assistant.expansion.util.ComUtil;
import cool.doudou.mybatis.assistant.generator.config.GlobalConfig;
import cool.doudou.mybatis.assistant.generator.config.PackageConfig;
import cool.doudou.mybatis.assistant.generator.entity.Column;
import cool.doudou.mybatis.assistant.generator.entity.Property;
import cool.doudou.mybatis.assistant.generator.entity.TableInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class OutputService {
    private final GlobalConfig globalConfig;
    private final PackageConfig packageConfig;

    public OutputService(GlobalConfig globalConfig, PackageConfig packageConfig) {
        this.globalConfig = globalConfig;
        this.packageConfig = packageConfig;
    }

    public void execute(TableInfo tableInfo) {
        Velocity.setProperty((String)"input.encoding", (Object)"UTF-8");
        Velocity.setProperty((String)"output.encoding", (Object)"UTF-8");
        Map<String, Object> contextMap = this.contextMap(tableInfo);
        Map<String, String> templateMap = this.templateMap((Map)contextMap.get("instance"));
        for (Map.Entry<String, String> entry : templateMap.entrySet()) {
            Object packagePath;
            String parentPath;
            String templateName = entry.getKey();
            String fileName = entry.getValue();
            if (templateName.endsWith("java.vm")) {
                parentPath = this.globalConfig.getOutputDir() + File.separator + "src" + File.separator + "main" + File.separator + "java";
                packagePath = this.packageConfig.getParent().replaceAll("\\.", File.separator) + File.separator + this.packageConfig.getPath(fileName);
            } else {
                parentPath = this.globalConfig.getOutputDir() + File.separator + "src" + File.separator + "main" + File.separator + "resources";
                packagePath = "mapper";
            }
            File parentFile = new File(parentPath + File.separator + (String)packagePath);
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                File file = new File(parentFile, fileName);
                if (!file.exists() || file.exists() && this.globalConfig.isCover()) {
                    FileWriter writer = new FileWriter(file);
                    Template template = Velocity.getTemplate((String)templateName, (String)StandardCharsets.UTF_8.name());
                    template.merge((Context)new VelocityContext(contextMap), (Writer)writer);
                    writer.flush();
                    writer.close();
                    continue;
                }
                System.err.println("file[" + file.getAbsolutePath() + "] exists.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.globalConfig.isOpenDir()) {
            this.openDir(this.globalConfig.getOutputDir());
        }
    }

    private void openDir(String directory) {
        try {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + directory);
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + directory);
                } else {
                    System.err.println("\u64cd\u4f5c\u7cfb\u7edf[" + osName + "]\u5339\u914d\u5931\u8d25: \u76ee\u5f55 => " + directory);
                }
            } else {
                System.err.println("\u64cd\u4f5c\u7cfb\u7edf\u83b7\u53d6\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, Object> contextMap(TableInfo tableInfo) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>(8);
        contextMap.put("tableName", tableInfo.getName());
        contextMap.put("tableNameAlias", ComUtil.underline2Hump((String)tableInfo.getName()) + "0");
        contextMap.put("tableComment", tableInfo.getComment());
        contextMap.put("author", this.globalConfig.getAuthor());
        contextMap.put("date", new SimpleDateFormat("yyyy/MM/dd").format(new Date()));
        contextMap.put("package", this.packageConfig);
        contextMap.put("instance", this.instance(tableInfo.getName(), tableInfo.getColumnList()));
        contextMap.put("xmlMap", this.xmlMap(tableInfo.getColumnList()));
        return contextMap;
    }

    private Map<String, Object> instance(String tableName, List<Column> columnList) {
        HashMap<String, Object> instanceMap = new HashMap<String, Object>();
        int firstIndex = tableName.indexOf("_");
        String name = ComUtil.underline2Hump((String)tableName.substring(firstIndex + 1));
        String className = ComUtil.upperFirst((String)name);
        instanceMap.put("controller", name + "Controller");
        instanceMap.put("controllerClass", className + "Controller");
        instanceMap.put("service", name + "Service");
        instanceMap.put("serviceClass", className + "Service");
        instanceMap.put("mapper", name + "Mapper");
        instanceMap.put("mapperClass", className + "Mapper");
        instanceMap.put("entity", name);
        instanceMap.put("entityClass", className);
        ArrayList propertyList = new ArrayList();
        HashSet importPackageSet = new HashSet();
        columnList.forEach(column -> {
            String columnName = column.getName();
            if (!("id".equals(columnName) || "create_by".equals(columnName) || "create_time".equals(columnName) || "update_by".equals(columnName) || "update_time".equals(columnName) || "deleted".equals(columnName))) {
                Property property = new Property();
                property.setName(ComUtil.underline2Hump((String)columnName));
                property.setJavaType(ComUtil.convert2JavaType((String)column.getDataType()));
                property.setComment(column.getComment());
                propertyList.add(property);
                switch (property.getJavaType()) {
                    case "LocalDate": {
                        importPackageSet.add("java.time.LocalDate");
                        break;
                    }
                    case "LocalTime": {
                        importPackageSet.add("java.time.LocalTime");
                        break;
                    }
                    case "LocalDateTime": {
                        importPackageSet.add("java.time.LocalDateTime");
                        break;
                    }
                    case "BigDecimal": {
                        importPackageSet.add("java.math.BigDecimal");
                        break;
                    }
                    case "Blob": {
                        importPackageSet.add("java.sql.Blob");
                    }
                }
            }
        });
        instanceMap.put("propertyList", propertyList);
        instanceMap.put("importPackageSet", importPackageSet);
        return instanceMap;
    }

    private Map<String, Object> xmlMap(List<Column> columnList) {
        HashMap<String, Object> xmlMap = new HashMap<String, Object>(3);
        ArrayList columnInsertList = new ArrayList();
        ArrayList columnUpdateList = new ArrayList();
        ArrayList propertyList = new ArrayList();
        ArrayList propertyInsertList = new ArrayList();
        ArrayList propertyUpdateList = new ArrayList();
        columnList.forEach(column -> {
            String columnName = column.getName();
            Property property = new Property();
            property.setName(ComUtil.underline2Hump((String)columnName));
            property.setJavaType(ComUtil.convert2JavaType((String)column.getDataType()));
            property.setComment(column.getComment());
            propertyList.add(property);
            if (!"update_by".equals(columnName) && !"update_time".equals(columnName)) {
                columnInsertList.add(column);
                propertyInsertList.add(property);
            }
            if (!("id".equals(columnName) || "create_by".equals(columnName) || "create_time".equals(columnName) || "deleted".equals(columnName))) {
                columnUpdateList.add(column);
                propertyUpdateList.add(property);
            }
        });
        xmlMap.put("columnList", columnList);
        xmlMap.put("columnInsertList", columnInsertList);
        xmlMap.put("columnUpdateList", columnUpdateList);
        xmlMap.put("propertyList", propertyList);
        xmlMap.put("propertyInsertList", propertyInsertList);
        xmlMap.put("propertyUpdateList", propertyUpdateList);
        return xmlMap;
    }

    private Map<String, String> templateMap(Map<String, Object> instanceMap) {
        String entityClass = String.valueOf(instanceMap.get("entityClass"));
        HashMap<String, String> templateMap = new HashMap<String, String>(5);
        templateMap.put("template/controller.java.vm", entityClass + "Controller.java");
        templateMap.put("template/service.java.vm", entityClass + "Service.java");
        templateMap.put("template/mapper.java.vm", entityClass + "Mapper.java");
        templateMap.put("template/entity.java.vm", entityClass + ".java");
        templateMap.put("template/mapper.xml.vm", entityClass + "Mapper.xml");
        return templateMap;
    }
}

