/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.generator;

import cool.doudou.mybatis.assistant.expansion.dialect.DialectHandlerFactory;
import cool.doudou.mybatis.assistant.expansion.dialect.IDialectHandler;
import cool.doudou.mybatis.assistant.generator.config.DataSourceConfig;
import cool.doudou.mybatis.assistant.generator.config.GlobalConfig;
import cool.doudou.mybatis.assistant.generator.config.PackageConfig;
import cool.doudou.mybatis.assistant.generator.config.TableConfig;
import cool.doudou.mybatis.assistant.generator.entity.DbTable;
import cool.doudou.mybatis.assistant.generator.output.OutputService;
import cool.doudou.mybatis.assistant.generator.table.TableService;
import java.util.Properties;
import org.apache.velocity.app.Velocity;

public class CodeGenerator {
    private final DataSourceConfig dataSourceConfig;
    private GlobalConfig globalConfig;
    private PackageConfig packageConfig;
    private TableConfig tableConfig;

    public CodeGenerator(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
        this.globalConfig = new GlobalConfig();
        this.packageConfig = new PackageConfig();
        this.tableConfig = new TableConfig();
    }

    public static CodeGenerator create(String ip, int port, String user, String password) {
        return new CodeGenerator(new DataSourceConfig(ip, port, user, password));
    }

    public CodeGenerator globalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public CodeGenerator packageConfig(PackageConfig packageConfig) {
        this.packageConfig = packageConfig;
        return this;
    }

    public CodeGenerator tableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
        return this;
    }

    public void execute() {
        Properties properties = new Properties();
        properties.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)properties);
        IDialectHandler dialectHandler = DialectHandlerFactory.getInstance((String)this.dataSourceConfig.getUrl());
        if (dialectHandler == null) {
            System.err.println("\u6570\u636e\u5e93\u65b9\u8a00\u5339\u914d\u5931\u8d25");
            return;
        }
        String driverClassName = dialectHandler.getDriverClassName();
        String tableSql = dialectHandler.getTableSql();
        String columnSql = dialectHandler.getColumnSql();
        TableService tableService = new TableService(this.dataSourceConfig, this.tableConfig);
        OutputService outputService = new OutputService(this.globalConfig, this.packageConfig);
        this.tableConfig.getNameList().forEach(tableName -> {
            DbTable dbTable = tableService.getInfo((String)tableName, driverClassName, tableSql, columnSql);
            if (dbTable != null) {
                outputService.execute(dbTable);
            }
        });
        System.out.println("code generator ok.");
    }
}

