/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.expansion.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComUtil {
    private static final Pattern linePattern = Pattern.compile("_(\\w)");
    private static final Pattern humpPattern = Pattern.compile("[A-Z]");

    public static String underline2Hump(String str) {
        Matcher matcher = linePattern.matcher(str);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String hump2Underline(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String upperFirst(String str) {
        return str.toUpperCase().charAt(0) + str.substring(1);
    }

    public static String lowerFirst(String str) {
        return str.toLowerCase().charAt(0) + str.substring(1);
    }

    public static String convert2JavaType(String dataType) {
        switch (dataType) {
            case "binary": {
                return "Byte[]";
            }
            case "bit": {
                return "Boolean";
            }
            case "char": 
            case "varchar": 
            case "text": {
                return "String";
            }
            case "smallint": 
            case "tinyint": 
            case "int": {
                return "Integer";
            }
            case "float": {
                return "Float";
            }
            case "double": {
                return "Double";
            }
            case "decimal": 
            case "numeric": {
                return "BigDecimal";
            }
            case "bigint": {
                return "Long";
            }
            case "date": {
                return "LocalDate";
            }
            case "time": {
                return "LocalTime";
            }
            case "datetime": 
            case "timestamp": {
                return "LocalDateTime";
            }
            case "blob": {
                return "Blob";
            }
        }
        System.err.println("dataType[" + dataType + "] match fail");
        return null;
    }
}

