/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.expansion.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BeanUtil {
    public static <T> Object getValue(T t, String name) {
        try {
            Field field = t.getClass().getDeclaredField(name);
            return field.get(t);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> void copy(T source, T target) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Arrays.stream(source.getClass().getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                properties.put(field.getName(), field.get(source));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        BeanUtil.populateBean(target, target.getClass(), properties);
        BeanUtil.populateBean(target, target.getClass().getSuperclass(), properties);
    }

    private static <T> void populateBean(T bean, Class clazz, Map<String, Object> properties) {
        Arrays.stream(clazz.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                if (properties.get(field.getName()) != null) {
                    field.set(bean, properties.get(field.getName()));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }
}

