/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.expansion.dialect;

import cool.doudou.mybatis.assistant.expansion.dialect.IDialectHandler;
import cool.doudou.mybatis.assistant.expansion.dialect.support.MySqlDialectHandler;
import cool.doudou.mybatis.assistant.expansion.dialect.support.OracleDialectHandler;
import cool.doudou.mybatis.assistant.expansion.dialect.support.PostgresSqlDialectHandler;
import cool.doudou.mybatis.assistant.expansion.dialect.support.SqlServerDialectHandler;
import java.util.HashMap;
import java.util.Map;

public class DialectHandlerFactory {
    private static final Map<String, IDialectHandler> URL_DIALECT_MAP = new HashMap<String, IDialectHandler>();

    public static IDialectHandler getInstance(String jdbcUrl) {
        for (String key : URL_DIALECT_MAP.keySet()) {
            if (!jdbcUrl.startsWith(key)) continue;
            return URL_DIALECT_MAP.get(key);
        }
        return null;
    }

    static {
        URL_DIALECT_MAP.put("jdbc:mysql", new MySqlDialectHandler());
        URL_DIALECT_MAP.put("jdbc:postgresql", new PostgresSqlDialectHandler());
        URL_DIALECT_MAP.put("jdbc:oracle", new OracleDialectHandler());
        URL_DIALECT_MAP.put("jdbc:sqlserver", new SqlServerDialectHandler());
    }
}

