/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.core.service;

import cool.doudou.mybatis.assistant.core.mapper.BaseMapper;
import cool.doudou.mybatis.assistant.core.page.Page;
import cool.doudou.mybatis.assistant.core.page.PageInfo;
import cool.doudou.mybatis.assistant.core.query.LambdaQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseService<M extends BaseMapper<T>, T> {
    @Autowired
    private M baseMapper;

    public T getById(Long id) {
        return this.baseMapper.selectById(id);
    }

    public T get(T t) {
        LambdaQuery<T> lambdaQuery = new LambdaQuery<T>(t);
        return this.baseMapper.selectOne(lambdaQuery);
    }

    public PageInfo<T> page(Page page, T t) {
        LambdaQuery<T> lambdaQuery = new LambdaQuery<T>(t);
        return PageInfo.of(this.baseMapper.selectList(page, lambdaQuery));
    }

    public boolean add(T t) {
        return this.retBool(this.baseMapper.insert(t));
    }

    public boolean edit(T t) {
        return this.retBool(this.baseMapper.update(t));
    }

    public boolean delete(String ids) {
        return this.retBool(this.baseMapper.deleteByIds(ids));
    }

    private boolean retBool(int count) {
        return count > 0;
    }
}

