/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.core.page;

import cool.doudou.mybatis.assistant.core.helper.PageHelper;
import cool.doudou.mybatis.assistant.core.page.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PageInfo<T> {
    private int pageNum;
    private int pageSize;
    private long total;
    private int pages = 0;
    private List<T> list = Collections.emptyList();

    public PageInfo(int pageNum, int pageSize, long total) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
    }

    public static <T> PageInfo<T> of(List<T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        long total = list.size();
        int pageNum = 1;
        int pageSize = 20;
        Page page = PageHelper.getLocalPage();
        if (page != null) {
            total = page.getTotal();
            pageNum = page.getPageNum();
            pageSize = page.getPageSize();
        }
        PageInfo<T> pageInfo = new PageInfo<T>(pageNum, pageSize, total);
        pageInfo.setPages(PageInfo.calcPages(total, pageSize));
        pageInfo.setList(list);
        return pageInfo;
    }

    private static int calcPages(long total, int pageSize) {
        int pages = 0;
        if (total > 0L) {
            pages = (int)(total / (long)pageSize);
            if (total % (long)pageSize != 0L) {
                ++pages;
            }
        }
        return pages;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public String toString() {
        return "PageInfo{pageNum=" + this.pageNum + ", pageSize=" + this.pageSize + ", total=" + this.total + ", pages=" + this.pages + ", list=" + this.list + "}";
    }
}

