/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.core.query;

import cool.doudou.mybatis.assistant.core.enums.SqlKeyword;
import cool.doudou.mybatis.assistant.expansion.util.ComUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IQuery<Child, R> {
    public static final String betweenStart = "Start";
    public static final String betweenEnd = "End";
    public static final List<String> whereList = new ArrayList<String>();
    public static final Map<String, Object> whereParamMap = new HashMap<String, Object>();
    public static final List<String> orderByList = new ArrayList<String>();
    public static final Set<String> groupBySet = new LinkedHashSet<String>();
    public static final Set<String> havingSet = new LinkedHashSet<String>();

    public Child eq(R var1, Object var2);

    public Child nEq(R var1, Object var2);

    public Child lk(R var1, Object var2);

    public Child lLk(R var1, Object var2);

    public Child rLk(R var1, Object var2);

    public Child nLk(R var1, Object var2);

    public Child lt(R var1, Object var2);

    public Child lte(R var1, Object var2);

    public Child gt(R var1, Object var2);

    public Child gte(R var1, Object var2);

    public Child in(R var1, Collection<?> var2);

    public Child between(R var1, Object var2, Object var3);

    public Child asc(R var1);

    public Child desc(R var1);

    public Child groupBy(R var1);

    public Child groupBy(R ... var1);

    public Child having(R var1, String var2, Object var3);

    public Child tenant(R var1, Object var2);

    public Child deleted();

    default public void where(String column, SqlKeyword sqlKeyword, Object value) {
        String propertyName = ComUtil.underline2Hump((String)column);
        whereList.add("(" + String.join((CharSequence)" ", column, sqlKeyword.get(), "#{q.param." + propertyName + "}") + ")");
        whereParamMap.put(propertyName, value);
    }

    default public void whereBetween(String column, Object valueStart, Object valueEnd) {
        String propertyName = ComUtil.underline2Hump((String)column);
        whereList.add("(" + String.join((CharSequence)" ", column, SqlKeyword.BETWEEN.get(), "#{q.param." + propertyName + "Start}", SqlKeyword.AND.get(), "#{q.param." + propertyName + "End}") + ")");
        whereParamMap.put(propertyName + betweenStart, valueStart);
        whereParamMap.put(propertyName + betweenEnd, valueEnd);
    }

    default public String getSql() {
        StringBuilder sbQuerySql = new StringBuilder();
        sbQuerySql.append(SqlKeyword.WHERE.get()).append(" ").append(String.join((CharSequence)(" " + SqlKeyword.AND.get() + " "), whereList));
        if (!groupBySet.isEmpty()) {
            sbQuerySql.append(" ").append(SqlKeyword.GROUP_BY.get()).append(" ").append(String.join((CharSequence)",", groupBySet));
            if (!havingSet.isEmpty()) {
                sbQuerySql.append(" ").append(SqlKeyword.HAVING.get()).append(" ").append(String.join((CharSequence)",", havingSet));
            }
        }
        if (!orderByList.isEmpty()) {
            sbQuerySql.append(" ").append(SqlKeyword.ORDER_BY.get()).append(" ").append(String.join((CharSequence)",", orderByList));
        }
        return sbQuerySql.toString();
    }

    default public Map<String, Object> getParam() {
        return whereParamMap;
    }
}

