/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mybatis.assistant.core.interceptors;

import cool.doudou.mybatiis.assistant.annotation.enums.CommandTypeEnum;
import cool.doudou.mybatis.assistant.core.fill.IFieldFillHandler;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class FieldFillInterceptor
implements Interceptor {
    private volatile IFieldFillHandler fieldFillHandler;

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        MetaObject metaObject = SystemMetaObject.forObject((Object)args[1]);
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (sqlCommandType.name().equals(CommandTypeEnum.INSERT.name())) {
            this.fieldFillHandler.insert(metaObject);
        } else if (sqlCommandType.name().equals(CommandTypeEnum.UPDATE.name())) {
            this.fieldFillHandler.update(metaObject);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        if (!properties.isEmpty()) {
            this.fieldFillHandler = (IFieldFillHandler)properties.get("fieldFillHandler");
        }
    }
}

