/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mqtt.assistant.core.processor;

import cool.doudou.mqtt.assistant.annotation.MqttClient;
import cool.doudou.mqtt.assistant.core.ConcurrentMapFactory;
import cool.doudou.mqtt.assistant.core.callback.MqttSubscribeCallback;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ClientBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ClientBeanPostProcessor.class);
    private String[] topics;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        boolean annotationPresent = bean.getClass().isAnnotationPresent(MqttClient.class);
        if (annotationPresent) {
            if (bean instanceof MqttSubscribeCallback) {
                MqttClient mqttClient = bean.getClass().getDeclaredAnnotation(MqttClient.class);
                this.initClient(mqttClient.topics(), this.topics, (MqttSubscribeCallback)bean);
            } else {
                log.warn("@MqttClient: bean[{}] should implements MqttSubscribeCallback", bean);
            }
        }
        return bean;
    }

    private void initClient(String[] topics, String[] subTopics, MqttSubscribeCallback callback) {
        if (topics == null || topics.length <= 0) {
            topics = subTopics;
        }
        Arrays.stream(topics).forEach(topic -> ConcurrentMapFactory.addCallback(topic, callback));
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public ClientBeanPostProcessor(String[] topics) {
        this.topics = topics;
    }
}

