/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mqtt.assistant.core.processor;

import cool.doudou.mqtt.assistant.annotation.MqttSubscriber;
import cool.doudou.mqtt.assistant.core.ConcurrentMapFactory;
import cool.doudou.mqtt.assistant.core.entity.SubscribeMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SubscriberBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SubscriberBeanPostProcessor.class);
    private String[] topics;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Arrays.stream(bean.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(MqttSubscriber.class)).forEach(method -> {
            MqttSubscriber mqttClient = method.getAnnotation(MqttSubscriber.class);
            this.initMethod(mqttClient.topics(), this.topics, bean, (Method)method);
        });
        return bean;
    }

    private void initMethod(String[] topics, String[] subTopics, Object bean, Method method) {
        if (topics == null || topics.length <= 0) {
            topics = subTopics;
        }
        Arrays.stream(topics).forEach(topic -> ConcurrentMapFactory.addMethod(topic, SubscribeMethod.builder().bean(bean).method(method).build()));
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public SubscriberBeanPostProcessor(String[] topics) {
        this.topics = topics;
    }
}

