/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mqtt.assistant.core.config;

import cool.doudou.mqtt.assistant.core.processor.ClientBeanPostProcessor;
import cool.doudou.mqtt.assistant.core.processor.SubscriberBeanPostProcessor;
import cool.doudou.mqtt.assistant.core.properties.MqttProperties;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.messaging.MessageChannel;

@IntegrationComponentScan(value={"cool.doudou.mqtt.assistant.core.handler"})
public class MqttConfig {
    private static final Logger log = LoggerFactory.getLogger(MqttConfig.class);
    private MqttProperties mqttProperties;

    @Bean
    public MqttPahoClientFactory mqttPahoClientFactory() {
        DefaultMqttPahoClientFactory factory = new DefaultMqttPahoClientFactory();
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        options.setServerURIs(new String[]{this.mqttProperties.getServerUri()});
        options.setUserName(this.mqttProperties.getUsername());
        options.setPassword(this.mqttProperties.getPassword().toCharArray());
        factory.setConnectionOptions(options);
        log.info("common-mqtt: serverUri[{}],clientId[{}]", (Object)this.mqttProperties.getServerUri(), (Object)this.mqttProperties.getClientId());
        return factory;
    }

    @Bean
    public MessageChannel mqttInboundChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageChannel mqttErrorChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageChannel mqttOutboundChannel() {
        return new DirectChannel();
    }

    @Bean
    public ClientBeanPostProcessor clientBeanPostProcessor() {
        return new ClientBeanPostProcessor(this.mqttProperties.getTopics());
    }

    @Bean
    public SubscriberBeanPostProcessor subscriberBeanPostProcessor() {
        return new SubscriberBeanPostProcessor(this.mqttProperties.getTopics());
    }

    public MqttConfig(MqttProperties mqttProperties) {
        this.mqttProperties = mqttProperties;
    }
}

