/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.mq.assistant.core.helper;

import cool.doudou.mq.assistant.core.ConcurrentMapFactory;
import cool.doudou.mq.assistant.core.helper.MqHelper;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarHelper
implements MqHelper {
    private static final Logger log = LoggerFactory.getLogger(PulsarHelper.class);

    @Override
    public String send(String topic, String msg) {
        return this.send(topic, msg.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String send(String topic, byte[] msgArr) {
        try {
            return ConcurrentMapFactory.get(topic).send((Object)msgArr).toString();
        }
        catch (PulsarClientException e) {
            log.error("send exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String send(String topic, String key, String msg) {
        return this.send(topic, key, msg.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String send(String topic, String key, byte[] msgArr) {
        try {
            return ConcurrentMapFactory.get(topic).newMessage().key(key).value((Object)msgArr).send().toString();
        }
        catch (PulsarClientException e) {
            log.error("send exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String send(String topic, String msg, long delay) {
        return this.send(topic, msg.getBytes(StandardCharsets.UTF_8), delay);
    }

    @Override
    public String send(String topic, byte[] msgArr, long delay) {
        try {
            return ConcurrentMapFactory.get(topic).newMessage().value((Object)msgArr).deliverAfter(delay, TimeUnit.MILLISECONDS).send().toString();
        }
        catch (PulsarClientException e) {
            log.error("send exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String send(String topic, String key, String msg, long delay) {
        return this.send(topic, key, msg.getBytes(StandardCharsets.UTF_8), delay);
    }

    @Override
    public String send(String topic, String key, byte[] msgArr, long delay) {
        try {
            return ConcurrentMapFactory.get(topic).newMessage().key(key).value((Object)msgArr).deliverAfter(delay, TimeUnit.MILLISECONDS).send().toString();
        }
        catch (PulsarClientException e) {
            log.error("send exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void sendAsync(String topic, String msg, Consumer<String> action) {
        this.sendAsync(topic, msg.getBytes(StandardCharsets.UTF_8), action);
    }

    @Override
    public void sendAsync(String topic, byte[] msgArr, Consumer<String> action) {
        CompletionStage completableFuture = ConcurrentMapFactory.get(topic).sendAsync((Object)msgArr).exceptionally(e -> {
            log.error("sendAsync exception: ", e);
            return null;
        });
        if (action != null) {
            ((CompletableFuture)completableFuture).thenAccept(messageId -> action.accept(messageId.toString()));
        }
    }

    @Override
    public void sendAsync(String topic, String key, String msg, Consumer<String> action) {
        this.sendAsync(topic, key, msg.getBytes(StandardCharsets.UTF_8), action);
    }

    @Override
    public void sendAsync(String topic, String key, byte[] msgArr, Consumer<String> action) {
        CompletionStage completableFuture = ConcurrentMapFactory.get(topic).newMessage().key(key).value((Object)msgArr).sendAsync().exceptionally(e -> {
            log.error("sendAsync exception: ", e);
            return null;
        });
        if (action != null) {
            ((CompletableFuture)completableFuture).thenAccept(messageId -> action.accept(messageId.toString()));
        }
    }

    @Override
    public void sendAsync(String topic, String msg, long delay, Consumer<String> action) {
        this.sendAsync(topic, msg.getBytes(StandardCharsets.UTF_8), delay, action);
    }

    @Override
    public void sendAsync(String topic, byte[] msgArr, long delay, Consumer<String> action) {
        CompletionStage completableFuture = ConcurrentMapFactory.get(topic).newMessage().value((Object)msgArr).deliverAfter(delay, TimeUnit.MILLISECONDS).sendAsync().exceptionally(e -> {
            log.error("sendAsync exception: ", e);
            return null;
        });
        if (action != null) {
            ((CompletableFuture)completableFuture).thenAccept(messageId -> action.accept(messageId.toString()));
        }
    }

    @Override
    public void sendAsync(String topic, String key, String msg, long delay, Consumer<String> action) {
        this.sendAsync(topic, key, msg.getBytes(StandardCharsets.UTF_8), delay, action);
    }

    @Override
    public void sendAsync(String topic, String key, byte[] msgArr, long delay, Consumer<String> action) {
        CompletionStage completableFuture = ConcurrentMapFactory.get(topic).newMessage().key(key).value((Object)msgArr).deliverAfter(delay, TimeUnit.MILLISECONDS).sendAsync().exceptionally(e -> {
            log.error("sendAsync exception: ", e);
            return null;
        });
        if (action != null) {
            ((CompletableFuture)completableFuture).thenAccept(messageId -> action.accept(messageId.toString()));
        }
    }
}

