/*
 * Decompiled with CFR 0.152.
 */
package cool.doudou.celery.common.mq.processor.producer;

import cool.doudou.celery.common.mq.ConcurrentMapFactory;
import cool.doudou.celery.common.mq.properties.PulsarProperties;
import cool.doudou.mq.assistant.annotation.MqProducer;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ProducerBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ProducerBeanPostProcessor.class);
    private PulsarClient pulsarClient;
    private PulsarProperties pulsarProperties;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        boolean annotationPresent = bean.getClass().isAnnotationPresent(MqProducer.class);
        if (annotationPresent) {
            MqProducer mqProducer = bean.getClass().getAnnotation(MqProducer.class);
            this.initProducer(mqProducer.topics());
        }
        return bean;
    }

    private void initProducer(String[] topics) {
        if (topics == null || topics.length <= 0) {
            log.error("initProducer error: @MqProducer.topics must be specified");
            return;
        }
        Arrays.stream(topics).forEach(topic -> {
            try {
                ConcurrentMapFactory.add(topic, (Producer<byte[]>)this.pulsarClient.newProducer().topic(topic).compressionType(CompressionType.valueOf((String)this.pulsarProperties.getCompressionType())).sendTimeout(this.pulsarProperties.getSendTimeout().intValue(), TimeUnit.SECONDS).enableBatching(this.pulsarProperties.getEnableBatching().booleanValue()).batchingMaxPublishDelay((long)this.pulsarProperties.getBatchingMaxPublishDelay().intValue(), TimeUnit.SECONDS).batchingMaxMessages(this.pulsarProperties.getBatchingMaxMessages().intValue()).blockIfQueueFull(this.pulsarProperties.getBlockIfQueueFull().booleanValue()).roundRobinRouterBatchingPartitionSwitchFrequency(this.pulsarProperties.getRoundRobinRouterBatchingPartitionSwitchFrequency().intValue()).create());
            }
            catch (PulsarClientException e) {
                log.error("initProducer[{}] exception: ", topic, (Object)e);
            }
        });
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public ProducerBeanPostProcessor(PulsarClient pulsarClient, PulsarProperties pulsarProperties) {
        this.pulsarClient = pulsarClient;
        this.pulsarProperties = pulsarProperties;
    }
}

